package io.gamedock.sdk.dailybonus;

import io.gamedock.sdk.utils.error.ErrorCodes;

/**
 * Interface used by the Daily Bonus Callbacks.
 * Describes all the methods that will be fired in the Daily Bonus Operations.
 */
public interface OnDailyBonusListener {
    void DailyBonusOpen();

    void DailyBonusClosed();

    void DailyBonusAvailable(String type);

    void DailyBonusNotAvailable();

    void DailyBonusError(ErrorCodes errorCode);

    void DailyBonusReward(String rewardList);
}
