package io.gamedock.sdk.assetbundles;

import com.unity3d.player.UnityPlayer;

import io.gamedock.sdk.utils.logging.LoggingUtil;

/**
 * Class that handles the Unity Asset Bundle Callbacks.
 * Informs the game if configurations are avaliable or not.
 */
public class AssetBundlesCallbacks {

    private OnAssetBundlesListener assetBundlesListener;

    public AssetBundlesCallbacks() {
        assetBundlesListener = null;
    }

    public AssetBundlesCallbacks(OnAssetBundlesListener assetBundlesListener) {
        this.assetBundlesListener = assetBundlesListener;
    }

    /**
     * Method called by the Asset Bundle manager when asset bundle configurations are available.
     */
    public void assetBundlesAvailable(String assetBundles) {
        if (assetBundlesListener != null) {
            assetBundlesListener.AssetBundlesAvailable(assetBundles);
        } else {
            try {
                UnityPlayer.UnitySendMessage("GamedockSDK", "AssetBundlesAvailable", assetBundles);
            } catch (NoClassDefFoundError e) {
                LoggingUtil.w("Tried to send information to Unity but UnityPlayer could not be found (NoClassDefFoundError). This can happen by design and is not necessarily a problem.");
            }
        }
    }

    /**
     * Method called by the Asset Bundle manager when asset bundle configurations are not available.
     */
    public void assetBundlesNotAvailable() {
        if (assetBundlesListener != null) {
            assetBundlesListener.AssetBundlesNotAvailable();
        } else {
            try {
                UnityPlayer.UnitySendMessage("GamedockSDK", "AssetBundlesNotAvailable", "");
            } catch (NoClassDefFoundError e) {
                LoggingUtil.w("Tried to send information to Unity but UnityPlayer could not be found (NoClassDefFoundError). This can happen by design and is not necessarily a problem.");
            }
        }
    }

}
