package io.gamedock.sdk.ads;

import android.content.Context;

import io.gamedock.sdk.ads.internal.GamedockMoreAppsManager;
import io.gamedock.sdk.utils.logging.LoggingUtil;

public class AdManager {
    private static final Object lock = new Object();

    private static volatile AdManager mInstance;
    ;

    public static AdManager getInstance() {
        if (mInstance == null) {
            synchronized (lock) {
                if (mInstance == null) {
                    mInstance = new AdManager();
                }
            }
        }
        return mInstance;
    }

    /**
     * Method used to request more apps from ChartBoost.
     */
    public void requestMoreApps(Context context) {
        GamedockMoreAppsManager.getInstance().requestGamedockMoreApps(context);
    }

    /**
     * Method used to show more apps.
     * Only Gamedock is used.
     */
    public void playMoreApps(Context context) {
        if (GamedockMoreAppsManager.getInstance().isMoreAppsEnabled) {
            GamedockMoreAppsManager.getInstance().showGamedockMoreApps(context);
        } else {
            LoggingUtil.d("Play MoreApps called but Gamedock More Apps not enabled requested yet.");
        }
    }
}
