package io.gamedock.sdk.ads;


import android.content.Context;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.events.Event;

/**
 * Class that handles all the internal events that are fired in regards to ads.
 * Handles events for interstitials, reward videos and more apps.
 */
public class AdEvents {

    public static final String AdvertisementInitialized = "advertisementInitialized";

    private static final String MoreAppsDidClose = "moreAppsDidClose";
    private static final String MoreAppsDidDisplay = "moreAppsDidDisplay";
    private static final String MoreAppsDidClick = "moreAppsDidClick";

    /**
     * Method that creates an event for when more apps has been closed and sends it to the backend.
     *
     * @param context The activity context.
     */
    public static void moreAppsDidClose(Context context) {
        Event event = new Event(context);
        event.setName(MoreAppsDidClose);

        GamedockSDK.getInstance(context).trackEvent(event, null);
    }

    /**
     * Method that creates an event for when more apps has been displayed and sends it to the backend.
     *
     * @param context The activity context.
     */
    public static void moreAppsDidDisplay(Context context) {
        Event event = new Event(context);
        event.setName(MoreAppsDidDisplay);

        GamedockSDK.getInstance(context).trackEvent(event, null);
    }

    /**
     * Method that creates an event for when more apps has been clicked and sends it to the backend.
     *
     * @param context The activity context.
     */
    public static void moreAppsDidClick(Context context) {
        Event event = new Event(context);
        event.setName(MoreAppsDidClick);

        GamedockSDK.getInstance(context).trackEvent(event, null);
    }

}