package io.gamedock.sdk.utils.thread;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;

import io.gamedock.sdk.GamedockSDK;

public class GamedockHandlerThread extends HandlerThread {
    public Context context;

    public GamedockHandlerThread(String name) {
        super(name);
    }

    @Override
    protected void onLooperPrepared() {
        super.onLooperPrepared();
        if (context != null) {
            GamedockSDK.getInstance(context).handler = new Handler(getLooper());
            context = null;
        }
    }

    @Override
    public synchronized void start() {
        super.start();
    }

    public void setContext(Context context) {
        this.context = context;
    }


}
