package io.gamedock.sdk.utils.privacy;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import io.gamedock.sdk.R;
import io.gamedock.sdk.models.config.PrivacyPolicyPartner;

public class PrivacyPolicyPartnerListAdapter extends RecyclerView.Adapter<PrivacyPolicyPartnerListAdapter.ViewHolder> {

    private int rowLayout;
    private ArrayList<PrivacyPolicyPartner> partners;
    private Context context;

    public PrivacyPolicyPartnerListAdapter(int rowLayout, ArrayList<PrivacyPolicyPartner> partners, Context context) {
        this.rowLayout = rowLayout;
        this.partners = partners;
        this.context = context;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        View view = LayoutInflater.from(viewGroup.getContext()).inflate(rowLayout, viewGroup, false);
        return new ViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int i) {
        viewHolder.privacyPolicyPartnerName.setText(partners.get(i).getName());
        viewHolder.privacyPolicyPartnerLink.setText(partners.get(i).getUrl());
        viewHolder.context = context;
        viewHolder.partnerUrl = partners.get(i).getUrl();
    }

    @Override
    public int getItemCount() {
        return partners.size();
    }

    public static class ViewHolder extends RecyclerView.ViewHolder {

        public TextView privacyPolicyPartnerName;

        public TextView privacyPolicyPartnerLink;

        public String partnerUrl;

        public Context context;

        public ViewHolder(View itemView) {
            super(itemView);

            privacyPolicyPartnerName = (TextView) itemView.findViewById(R.id.privacyPolicyPartnerName);
            privacyPolicyPartnerLink = (TextView) itemView.findViewById(R.id.privacyPolicyPartnerLink);

            itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(partnerUrl));
                    context.startActivity(browserIntent);
                }
            });
        }
    }
}
