package io.gamedock.sdk.utils.permissions.air;

import android.app.Activity;
import android.os.Bundle;

import androidx.annotation.NonNull;

import java.util.HashMap;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.utils.logging.LoggingUtil;
import io.gamedock.sdk.utils.permissions.PermissionUtil;

public class AIRPermissionActivity extends Activity {

    private static Activity activity;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        activity = this;

        Bundle extras = this.getIntent().getExtras();

        if (extras != null) {
            String request = extras.getString("request", null);

            if (request != null) {
                if (request.equals("all")) {
                    LoggingUtil.d("AIR: Requesting all permissions from Activity");
                    PermissionUtil.requestAllDangerousPermissions(this, true, true, true);
                } else if (request.equals("single")) {
                    LoggingUtil.d("AIR: Requesting single permission from AIR Activity");
                    String permission = extras.getString("permission", null);
                    String rationale = extras.getString("rationale", null);
                    String denyRationale = extras.getString("denyRationale", "");

                    if (permission != null && rationale != null) {
                        HashMap<String, PermissionUtil.PermissionRationaleTemp> permissionsMap = new HashMap<>();

                        PermissionUtil.PermissionRationaleTemp permissionRationaleTemp = new PermissionUtil.PermissionRationaleTemp();
                        permissionRationaleTemp.rationale = rationale;
                        permissionRationaleTemp.denyRationale = denyRationale;

                        permissionsMap.put(permission, permissionRationaleTemp);

                        PermissionUtil.requestPermissions(this, permissionsMap, true, true, true);
                    } else {
                        LoggingUtil.d("Something went wrong with requesting permission!");
                    }

                }
            }
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);

        GamedockSDK.getInstance(this).onRequestPermissionsResult(requestCode, permissions, grantResults);
        finish();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();

        GamedockSDK.getInstance(this).isShowingChildActivity = false;
    }

    public static void closeActivity() {
        if (activity != null) {
            activity.finish();
        }
    }
}
