package io.gamedock.sdk.utils.performance;

import android.content.Context;
import android.net.TrafficStats;

/**
 * Class used by the SDK to perform various Network trafiic metrics operations.
 */
public class NetworkInfo {

    /**
     * Method used to retrieve the total traffic sent since the application has been installed.
     * @param context The application context.
     * @return The network traffic sent by the application in kilobytes.
     */
    public static long getNetworkTrafficSent(Context context) {
        try {
            return TrafficStats.getUidTxBytes(context.getApplicationInfo().uid) / 1024L;
        } catch (Exception e) {
            return 0;
        }
    }

    /**
     * Method used to retrieve the total traffic received since the application has been installed.
     * @param context The application context.
     * @return The network traffic received by the application in kilobytes.
     */
    public static long getNetworkTrafficReceived(Context context) {
        try {
            return TrafficStats.getUidRxBytes(context.getApplicationInfo().uid) / 1024L;
        } catch (Exception e) {
            return 0;
        }
    }
}
