package io.gamedock.sdk.utils.images.cache;

import com.nostra13.universalimageloader.cache.disc.naming.FileNameGenerator;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ImageFileNameGenerator implements FileNameGenerator {

    private static final String HASH_ALGORITHM = "MD5";
    private static final int RADIX = 36;

    public ImageFileNameGenerator() {
    }

    @Override
    public String generate(String imageUri) {
        byte[] md5 = this.getMD5(imageUri.getBytes());
        BigInteger bi = (new BigInteger(md5)).abs();
        String extension = "";
        if(imageUri.contains(".")) {
            extension = imageUri.substring(imageUri.lastIndexOf("."));
        }
        return bi.toString(RADIX) + extension;
    }

    private byte[] getMD5(byte[] data) {
        byte[] hash = null;

        try {
            MessageDigest e = MessageDigest.getInstance(HASH_ALGORITHM);
            e.update(data);
            hash = e.digest();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }

        return hash;
    }
}
