package io.gamedock.sdk.utils.images;

import io.gamedock.sdk.models.image.ImageContext;
import io.gamedock.sdk.utils.error.ErrorCodes;

/**
 * Interface used by the Image Loading Callbacks.
 * Describes all the methods that will be fired in the Image Loading Operations.
 */
public interface OnImageLoadListener {
    void ImageLoadSuccess(String localPath, ImageContext imageContext);

    void ImageLoadFailed(ImageContext imageContext, ErrorCodes errorCode);

    void ImagePreLoadingCompleted();
}
