package io.gamedock.sdk.utils.gcm;

import android.content.Context;
import android.content.SharedPreferences;

import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.utils.logging.LoggingUtil;

/**
 * Utility class that handles all the logic for storing and retrieving GCM id
 */
public class GCMUtils {

    private static String TAG = "GcmUtilsGamedockSDK";

    /**
     * Method that stores the GCM Id received from Google.
     *
     * @param context The activity context.
     * @param token   The GCM Id that has been generated by Google.
     */
    public static void storeGCM(Context context, String token) {
        String oldToken = GamedockSDK.getInstance(context).getStorageUtil().getString("gcm_id", null);

        if (oldToken == null && token != null) {
            LoggingUtil.d("Stored new token " + token);
            GamedockSDK.getInstance(context).getStorageUtil().putString("gcm_id", token);
        } else if (oldToken != null && token != null && !oldToken.equals(token)) {
            LoggingUtil.d("Updated with new token " + token);
            GamedockSDK.getInstance(context).getStorageUtil().putString("gcm_id", token);
        } else {
            LoggingUtil.d("No token changes needed");
        }
    }

    /**
     * Method that retrieves the GCM Id stored in the {@link SharedPreferences}.
     *
     * @param context The activity context.
     * @return Returns the locally saved GCM Id or {@code null} if none has been received from Google.
     */
    public static String getGCMID(Context context) {
        return GamedockSDK.getInstance(context).getStorageUtil().getString("gcm_id", "");
    }

    /**
     * Method that checks if Google Play Services are present on the device and shows a prompt to install them if they are not.
     *
     * @param context The activity context.
     * @return Returns {@code true} if Google Play Services are present on the device.
     */
    public static boolean checkPlayServices(final Context context) {
        final GoogleApiAvailability apiAvailability = GoogleApiAvailability.getInstance();
        final int resultCode = apiAvailability.isGooglePlayServicesAvailable(context);
        return resultCode == ConnectionResult.SUCCESS;
    }
}