package io.gamedock.sdk.utils.gcm;

import androidx.annotation.NonNull;

import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;

import org.json.JSONObject;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.events.response.ResponseEvent;
import io.gamedock.sdk.utils.logging.LoggingUtil;

/**
 * Class used by the Google Play Services GCM for generating a GCM Id.
 */
public class GCMListenerService extends FirebaseMessagingService {
    @Override
    public void onNewToken(@NonNull String token) {
        super.onNewToken(token);

        LoggingUtil.i("Received GCM Registration Token: " + token);
        GCMUtils.storeGCM(this, token);
    }

    @Override
    public void onMessageReceived(@NonNull RemoteMessage message) {
        LoggingUtil.d("Handling incoming notification");

        try {
            if (message.getData().isEmpty()) {
                LoggingUtil.e("no message found in message");
                return;
            }

            JSONObject messageJSON = new JSONObject(message.getData().get("message"));
            ResponseEvent responseEvent = ResponseEvent.Build(messageJSON.toString());
            GamedockSDK.getInstance(this).processResponseEvent(responseEvent, null);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
