package io.gamedock.sdk.utils.dialog.internal;

import android.content.Context;
import android.util.TypedValue;

import androidx.annotation.ColorRes;
import androidx.core.content.ContextCompat;

import io.gamedock.sdk.R;

public class UtilsLibrary {

    public static int getPrimaryColor(Context context) {
        TypedValue typedValue = new TypedValue();

        context.getTheme().resolveAttribute(R.color.colorPrimary, typedValue, true);

        return typedValue.data;
    }

    public static int dpToPixels(Context context, int dp) {
        final float scale = context.getResources().getDisplayMetrics().density;
        return (int) (dp * scale + 0.5f);
    }

    public static int getColor(Context context, @ColorRes int colorId) {
        return ContextCompat.getColor(context, colorId);
    }
}
