package io.gamedock.sdk.utils.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.View;

import io.gamedock.sdk.utils.dialog.internal.MDRootLayout;

public class DialogBase extends Dialog implements DialogInterface.OnShowListener {

    protected MDRootLayout view;
    private DialogInterface.OnShowListener showListener;

    public DialogBase(Context context, int theme) {
        super(context, theme);
    }

    @Override
    public View findViewById(int id) {
        return view.findViewById(id);
    }

    @Override
    public final void setOnShowListener(DialogInterface.OnShowListener listener) {
        showListener = listener;
    }

    final void setOnShowListenerInternal() {
        super.setOnShowListener(this);
    }

    final void setViewInternal(View view) {
        super.setContentView(view);
    }

    @Override
    public void onShow(DialogInterface dialog) {
        if (showListener != null)
            showListener.onShow(dialog);
    }
}
