package io.gamedock.sdk.utils.crash;

import com.google.firebase.crashlytics.FirebaseCrashlytics;

import org.json.JSONArray;
import org.json.JSONObject;

import io.gamedock.sdk.utils.logging.LoggingUtil;

/**
 * Class used to interact with the Firebase Crashlytics API.
 */
public class FirebaseCrashlyticsUtil {

    /**
     * Method used to sent a custom exception through Crashlytics.
     *
     * @param name            The name of the exception.
     * @param reason          The reason of the exception
     * @param stackTraceArray A JSON stack trace array containing all the stack traces related to the exception.
     */
    public static void recordCustomException(String name, String reason, String stackTraceArray) {
        try {
            String exceptionName = name + " : " + reason;

            Exception exception = new Exception(exceptionName);

            JSONArray stackTraceArrayJSON = new JSONArray(stackTraceArray);

            StackTraceElement[] traceArray = new StackTraceElement[stackTraceArrayJSON.length()];

            for (int i = 0; i < stackTraceArrayJSON.length(); i++) {
                JSONObject frame = stackTraceArrayJSON.getJSONObject(i);

                String declaringClass = frame.getString("class");
                String method = frame.getString("method");
                String file = frame.getString("file");
                int line = frame.getInt("line");

                StackTraceElement stackTraceElement = new StackTraceElement(declaringClass, method, file, line);
                traceArray[i] = stackTraceElement;
            }

            exception.setStackTrace(traceArray);

            FirebaseCrashlytics.getInstance().recordException(exception);
            LoggingUtil.d("Firebase Crashlytics uploaded error: " + exception);
        } catch (Exception e) {
            LoggingUtil.e("Gamedock Firebase Module not included! If you want to use Firebase please include the gamedock-sdk-firebase dependency");
        }
    }
}
