package io.gamedock.sdk.utils.azerionConnect;

import androidx.annotation.NonNull;

import net.openid.appauth.browser.BrowserDescriptor;
import net.openid.appauth.browser.BrowserMatcher;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class BrowserWhitelist implements BrowserMatcher {
    private List<BrowserMatcher> mBrowserMatchers;

    public BrowserWhitelist(BrowserMatcher... matchers) {
        this.mBrowserMatchers = Arrays.asList(matchers);
    }

    public boolean matches(@NonNull BrowserDescriptor descriptor) {
        Iterator var2 = this.mBrowserMatchers.iterator();

        BrowserMatcher matcher;
        do {
            if (!var2.hasNext()) {
                return false;
            }

            matcher = (BrowserMatcher)var2.next();
        } while(!matcher.matches(descriptor));

        return true;
    }
}
