package io.gamedock.sdk.utils.azerionConnect;


import com.unity3d.player.UnityPlayer;

import org.json.JSONException;
import org.json.JSONObject;

import io.gamedock.sdk.utils.agegate.OnAgeGateListener;
import io.gamedock.sdk.utils.logging.LoggingUtil;

public class AzerionConnectCallbacks {

    private OnAzerionConnectListener azerionConnectListener;

    public AzerionConnectCallbacks() {
        azerionConnectListener = null;
    }
    public AzerionConnectCallbacks(OnAzerionConnectListener azerionConnectListener) {
        this.azerionConnectListener = azerionConnectListener;
    }


    public void azerionSuccessful(String info) {
        if (azerionConnectListener != null) {
            azerionConnectListener.AzerionSuccessful(info);
        } else {
            try {


                UnityPlayer.UnitySendMessage("GamedockSDK", "AzerionLoginSuccessful", info);
            } catch (NoClassDefFoundError e) {
                LoggingUtil.w("You need to register the AzerionConnectCallbacks in order to receive information or something went wrong with Unity");
            }
        }
    }

    public void azerionFailed() {
        if (azerionConnectListener != null) {
            azerionConnectListener.AzerionFailed();
        } else {
            try {


                UnityPlayer.UnitySendMessage("GamedockSDK", "AzerionLoginFailed", "");
            } catch (NoClassDefFoundError e) {
                LoggingUtil.w("You need to register the AzerionConnectCallbacks in order to receive information or something went wrong with Unity");
            }
        }
    }


}
