package io.gamedock.sdk.utils.apprate;

import android.content.Context;
import android.content.Intent;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.utils.logging.LoggingUtil;
import io.gamedock.sdk.utils.storage.StorageUtil;

public class AppRateUtil {
    public static void showAppRatePopup(Context context, String rejectText, String laterText, String message, String feedbackUrl, int triggerCount, int laterCount) {
        boolean appRateNeverShow = GamedockSDK.getInstance(context).getStorageUtil().getBoolean(StorageUtil.Keys.AppRateNeverShow, false);
        if (appRateNeverShow) {
            LoggingUtil.d("AppRate user selected to never see app rate popup.");
            return;
        }

        boolean appRateShown = GamedockSDK.getInstance(context).getStorageUtil().getBoolean(StorageUtil.Keys.AppRateShown, false);
        if (appRateShown) {
            boolean appRateLaterOptionSelected = GamedockSDK.getInstance(context).getStorageUtil().getBoolean(StorageUtil.Keys.AppRateLaterOptionSelected, false);
            if (appRateLaterOptionSelected) {
                int currentLaterCount = GamedockSDK.getInstance(context).getStorageUtil().getInt(StorageUtil.Keys.AppRateLaterCount, 0);
                currentLaterCount++;

                if (currentLaterCount < laterCount) {
                    GamedockSDK.getInstance(context).getStorageUtil().putInt(StorageUtil.Keys.AppRateLaterCount, currentLaterCount);
                } else if (currentLaterCount == laterCount) {
                    GamedockSDK.getInstance(context).getStorageUtil().putInt(StorageUtil.Keys.AppRateLaterCount, currentLaterCount);
                    startAppRateActivity(context, rejectText, laterText, message, feedbackUrl);
                }
            }
        } else {
            int currentTriggerCount = GamedockSDK.getInstance(context).getStorageUtil().getInt(StorageUtil.Keys.AppRateTriggerCount, 0);
            currentTriggerCount++;

            if (currentTriggerCount < triggerCount) {
                GamedockSDK.getInstance(context).getStorageUtil().putInt(StorageUtil.Keys.AppRateTriggerCount, currentTriggerCount);
            } else if (currentTriggerCount == triggerCount) {
                GamedockSDK.getInstance(context).getStorageUtil().putInt(StorageUtil.Keys.AppRateTriggerCount, currentTriggerCount);
                GamedockSDK.getInstance(context).getStorageUtil().putBoolean(StorageUtil.Keys.AppRateShown, true);
                startAppRateActivity(context, rejectText, laterText, message, feedbackUrl);
            }
        }
    }

    private static void startAppRateActivity(Context context, String rejectText, String laterText, String message, String feedbackUrl) {
        GamedockSDK.getInstance(context).isShowingChildActivity = true;

        Intent intent = new Intent(context, AppRateActivity.class);
        intent.putExtra("rejectText", rejectText);
        intent.putExtra("laterText", laterText);
        intent.putExtra("messageText", message);
        intent.putExtra("feedbackUrl", feedbackUrl);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);

        context.startActivity(intent);
    }
}
