package io.gamedock.sdk.utils.apprate;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.Nullable;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.R;
import io.gamedock.sdk.utils.storage.StorageUtil;

public class AppRateActivity extends Activity {

    public AppRateActivity activity;
    private Handler handler;

    private TextView appRateMessage;

    private ImageView oneStarRate;
    private ImageView twoStarRate;
    private ImageView threeStarRate;
    private ImageView fourStarRate;
    private ImageView fiveStarRate;

    private Button appRateButtonReject;
    private Button appRateButtonLater;

    private String feedbackUrl;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_app_rate);

        activity = this;
        handler = new Handler(Looper.getMainLooper());

        try {
            overridePendingTransition(android.R.anim.slide_in_left, android.R.anim.slide_out_right);
        } catch (Error | Exception ignored) {
        }

        ImageView appRateImage = findViewById(R.id.appRateImage);
        appRateMessage = findViewById(R.id.appRateMessage);
        oneStarRate = findViewById(R.id.oneStarRate);
        twoStarRate = findViewById(R.id.twoStarRate);
        threeStarRate = findViewById(R.id.threeStarRate);
        fourStarRate = findViewById(R.id.fourStarRate);
        fiveStarRate = findViewById(R.id.fiveStarRate);
        appRateButtonReject = findViewById(R.id.appRateButtonReject);
        appRateButtonLater = findViewById(R.id.appRateButtonLater);

        try {
            int orientation = getResources().getConfiguration().orientation;
            String imageName = orientation == Configuration.ORIENTATION_PORTRAIT ? "privacy_policy_portrait_custom" : "privacy_policy_landscape_custom";

            int resourceId = getResources().getIdentifier(imageName, "drawable", getPackageName());
            if (resourceId != 0) {
                appRateImage.setBackgroundResource(resourceId);
            }
        } catch (Error | Exception e) {
            e.printStackTrace();
        }

        if (getIntent() == null) {
            finish();
            return;
        }

        Bundle args = getIntent().getExtras();
        if (args == null) {
            finish();
            return;
        }

        String rejectText = args.getString("rejectText");
        String laterText = args.getString("laterText");
        String messageText = args.getString("messageText");

        feedbackUrl = args.getString("feedbackUrl");

        appRateMessage.setText(messageText);
        appRateButtonReject.setText(rejectText);
        appRateButtonLater.setText(laterText);

        try {
            oneStarRate.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    oneStarRate.setImageResource(R.drawable.app_rating_full);
                    handler.postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            openFeedback();
                        }
                    }, 1000);
                }
            });
            twoStarRate.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    oneStarRate.setImageResource(R.drawable.app_rating_full);
                    twoStarRate.setImageResource(R.drawable.app_rating_full);
                    handler.postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            openFeedback();
                        }
                    }, 1000);
                }
            });
            threeStarRate.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    oneStarRate.setImageResource(R.drawable.app_rating_full);
                    twoStarRate.setImageResource(R.drawable.app_rating_full);
                    threeStarRate.setImageResource(R.drawable.app_rating_full);
                    handler.postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            openFeedback();
                        }
                    }, 1000);
                }
            });
            fourStarRate.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    oneStarRate.setImageResource(R.drawable.app_rating_full);
                    twoStarRate.setImageResource(R.drawable.app_rating_full);
                    threeStarRate.setImageResource(R.drawable.app_rating_full);
                    fourStarRate.setImageResource(R.drawable.app_rating_full);
                    handler.postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            openStoreForRate();
                        }
                    }, 1000);
                }
            });
            fiveStarRate.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    oneStarRate.setImageResource(R.drawable.app_rating_full);
                    twoStarRate.setImageResource(R.drawable.app_rating_full);
                    threeStarRate.setImageResource(R.drawable.app_rating_full);
                    fourStarRate.setImageResource(R.drawable.app_rating_full);
                    fiveStarRate.setImageResource(R.drawable.app_rating_full);
                    handler.postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            openStoreForRate();
                        }
                    }, 1000);
                }
            });
            appRateButtonReject.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    GamedockSDK.getInstance(activity).getStorageUtil().putBoolean(StorageUtil.Keys.AppRateNeverShow, true);
                    activity.finish();
                }
            });
            appRateButtonLater.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    GamedockSDK.getInstance(activity).getStorageUtil().putBoolean(StorageUtil.Keys.AppRateLaterOptionSelected, true);
                    activity.finish();
                }
            });
        } catch (NullPointerException e) {
            finish();
        }
    }

    @Override
    protected void onResume() {
        super.onResume();

        clearStarImages();
        starImagesClickable(true);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();

        GamedockSDK.getInstance(this).isShowingChildActivity = false;
    }

    private void openFeedback() {
        starImagesClickable(false);

        Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(feedbackUrl));
        startActivity(intent);

        activity.finish();
    }

    private void openStoreForRate() {
        if (activity == null) {
            return;
        }

        starImagesClickable(false);

        Uri uri = Uri.parse("market://details?id=" + activity.getPackageName());
        Intent intent = new Intent(Intent.ACTION_VIEW, uri);
        intent.addFlags(Intent.FLAG_ACTIVITY_NO_HISTORY | Intent.FLAG_ACTIVITY_NEW_DOCUMENT | Intent.FLAG_ACTIVITY_MULTIPLE_TASK);
        try {
            startActivity(intent);
        } catch (ActivityNotFoundException e) {
            startActivity(new Intent(Intent.ACTION_VIEW,
                    Uri.parse("http://play.google.com/store/apps/details?id=" + activity.getPackageName())));
        }

        activity.finish();
    }

    private void starImagesClickable(boolean clickable) {
        oneStarRate.setClickable(clickable);
        twoStarRate.setClickable(clickable);
        threeStarRate.setClickable(clickable);
        fourStarRate.setClickable(clickable);
        fiveStarRate.setClickable(clickable);
    }

    private void clearStarImages() {
        oneStarRate.setImageResource(R.drawable.app_rating_empty);
        twoStarRate.setImageResource(R.drawable.app_rating_empty);
        threeStarRate.setImageResource(R.drawable.app_rating_empty);
        fourStarRate.setImageResource(R.drawable.app_rating_empty);
        fiveStarRate.setImageResource(R.drawable.app_rating_empty);
    }
}
