package io.gamedock.sdk.utils.agegate;

import com.unity3d.player.UnityPlayer;

import org.json.JSONException;
import org.json.JSONObject;

import io.gamedock.sdk.utils.logging.LoggingUtil;

public class AgeGateCallbacks {

    private OnAgeGateListener ageGateListener;

    public AgeGateCallbacks() {
        ageGateListener = null;
    }

    public AgeGateCallbacks(OnAgeGateListener ageGateListener) {
        this.ageGateListener = ageGateListener;
    }

    /**
     * Method that is called to notify the status of the age gate popup.
     */
    public void ageGateStatus(boolean passed, String age, boolean checkPrivacyPolicy) {
        if (ageGateListener != null) {
            ageGateListener.AgeGateStatus(passed, age, checkPrivacyPolicy);
        } else {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("passed", passed);
                jsonObject.put("age", age);
                jsonObject.put("checkPrivacyPolicy", checkPrivacyPolicy);

                UnityPlayer.UnitySendMessage("GamedockSDK", "AgeGateStatus", jsonObject.toString());
            } catch (NoClassDefFoundError | JSONException e) {
                LoggingUtil.w("You need to register the AgeGateCallbacks in order to receive information or something went wrong with Unity");
            }
        }
    }

}
