package io.gamedock.sdk.pushnotifications;


import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.ArrayList;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.models.notification.GamedockNotification;
import io.gamedock.sdk.utils.storage.StorageUtil;

/**
 * Class that handles the {@link BroadcastReceiver} when a notification has been dismissed.
 * Sends an Event informing that the notification has been dismissed.
 */
public class NotificationDismissedReceiver extends BroadcastReceiver {

    @Override
    public void onReceive(Context context, Intent intent) {
        int creationId = intent.getExtras().getInt("creationId", 0);
        String uniqueNotificationID = intent.getExtras().getString("uniqueNotificationID", null);

        NotificationManager.sendNotificationEvent(context, uniqueNotificationID, "notificationDismissed", false, "remote");

        if (creationId != 0 && uniqueNotificationID != null) {
            intent.getExtras().remove("creationId");
            intent.getExtras().remove("uniqueNotificationID");

            ArrayList<GamedockNotification> notificationsList;
            String notificationListString = GamedockSDK.getInstance(context).getStorageUtil().getString(StorageUtil.Keys.NotificationDataList, null);

            if (notificationListString != null) {
                Type notificationListType = new TypeToken<ArrayList<GamedockNotification>>() {
                }.getType();
                notificationsList = GamedockSDK.getInstance(context).getGson().fromJson(notificationListString, notificationListType);
            } else {
                notificationsList = new ArrayList<>();
            }

            for (int i = 0; i < notificationsList.size(); i++) {
                if(notificationsList.get(i).uniqueNotificationId.equals(uniqueNotificationID)) {
                    notificationsList.get(i).dismissed = true;
                }
            }

            GamedockSDK.getInstance(context).getStorageUtil().putString(StorageUtil.Keys.NotificationDataList, GamedockSDK.getInstance(context).getGson().toJson(notificationsList));
        }
    }
}
