package io.gamedock.sdk.network;

import androidx.annotation.NonNull;

import com.evernote.android.job.Job;
import com.evernote.android.job.JobCreator;

import io.gamedock.sdk.pushnotifications.NotificationManager;

public class NetworkJobCreator implements JobCreator{
    @Override
    public Job create(@NonNull String tag) {
        switch (tag) {
            case NetworkJob.PersistJob.TAG:
                return new NetworkJob.PersistJob();
            case NotificationManager.NotificationJob.TAG:
                return new NotificationManager.NotificationJob();
            default:
                return null;
        }
    }
}
