package io.gamedock.sdk.models.userdata.wallet;

import com.google.gson.Gson;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import io.gamedock.sdk.userdata.playerdata.PlayerDataManager;

public class Wallet {

    private ConcurrentHashMap<Integer, PlayerCurrency> currenciesMap = new ConcurrentHashMap<>();
    private ArrayList<PlayerCurrency> currencies = new ArrayList<>();

    private long offset;
    private String logic;

    public long getOffset() {
        return offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public String getLogic() {
        return logic;
    }

    public void setLogic(String logic) {
        this.logic = logic;
    }

    public ConcurrentHashMap<Integer, PlayerCurrency> getCurrenciesMap() {
        return currenciesMap;
    }

    public void setCurrenciesMap(ConcurrentHashMap<Integer, PlayerCurrency> currenciesMap) {
        this.currenciesMap = currenciesMap;
    }

    public ArrayList<PlayerCurrency> getCurrencies() {
        return currencies;
    }

    public void setCurrencies(ArrayList<PlayerCurrency> currencies) {
        this.currencies = currencies;
    }

    public void updateCurrency(ArrayList<PlayerCurrency> tempCurrencies) {
        for (int i = 0; i < tempCurrencies.size(); i++) {
            PlayerCurrency temp = tempCurrencies.get(i);
            currenciesMap.get(temp.getId()).setDelta(temp.getDelta());
            currenciesMap.get(temp.getId()).setCurrentBalance(temp.getCurrentBalance());
        }
    }

    public void updateCurrency(PlayerCurrency tempCurrency) {
        currenciesMap.get(tempCurrency.getId()).setDelta(tempCurrency.getDelta());
        currenciesMap.get(tempCurrency.getId()).setCurrentBalance(tempCurrency.getCurrentBalance());
    }

    public Wallet BuildForJson() {
        Wallet data = new Wallet();

        data.currencies.addAll(currenciesMap.values());

        data.setOffset(offset);
        data.setLogic(logic);

        return data;
    }

    public JSONObject toJson(Gson gson) {
        JSONObject walletJSON = null;
        try {
            walletJSON = new JSONObject(gson.toJson(this));
            walletJSON.remove(PlayerDataManager.CurrenciesMap);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        return walletJSON;
    }

    public Wallet clone() {
        Wallet clone = new Wallet();

        if(currenciesMap != null) {
            for(Map.Entry<Integer, PlayerCurrency> entry : currenciesMap.entrySet()) {
                clone.getCurrenciesMap().put(entry.getKey(), entry.getValue());
            }
        }

        if(currencies != null) {
            for(PlayerCurrency playerCurrency : currencies) {
                clone.getCurrencies().add(playerCurrency.clone());
            }
        }

        clone.setOffset(offset);
        clone.setLogic(logic);

        return clone;
    }
}
