package io.gamedock.sdk.models.userdata.inventory;


import io.gamedock.sdk.models.gamedata.gacha.GachaContent;
import io.gamedock.sdk.models.gamedata.items.Item;

public class PlayerItem extends Item {

    private int amount;
    private int delta;
    private int value;
    private int overflow;

    public PlayerItem() {
        super();
    }

    public PlayerItem(Item item) {
        setId(item.getId());
        setName(item.getName());
        setType(item.getType());
        setAmount(0);
        setDelta(0);
        setReportingName(item.getReportingName());
        setDisplayName(item.getDisplayName());
        setDisplayDescription(item.getDisplayDescription());
        setImageUrl(item.getImageUrl());

        setGacha(item.isGacha());
        setContent(item.getContent());
        setAllowDuplicates(item.doesAllowDuplicates());
        setShouldReroll(item.shouldReroll());
        setDuplicateReward(item.getDuplicateReward());
        setProperties(item.getProperties());
        setLimit(item.getLimit());
        setUnique(item.isUnique());
    }

    public int getAmount() {
        return amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public int getDelta() {
        return delta;
    }

    public void setDelta(int delta) {
        this.delta = delta;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public int getOverflow() {
        return overflow;
    }

    public void setOverflow(int overflow) {
        this.overflow = overflow;
    }

    public PlayerItem clone() {
        PlayerItem clone = new PlayerItem();

        clone.setAmount(amount);
        clone.setDelta(delta);
        clone.setValue(value);

        clone.setId(getId());
        clone.setName(getName());
        clone.setInitialValue(getInitialValue());
        clone.setType(getType());
        clone.setReportingName(getReportingName());
        clone.setDisplayName(getDisplayName());
        clone.setDisplayDescription(getDisplayDescription());
        clone.setImageUrl(getImageUrl());

        clone.setGacha(isGacha());
        clone.setAllowDuplicates(doesAllowDuplicates());
        clone.setShouldReroll(shouldReroll());
        clone.setDuplicateReward(getDuplicateReward());

        if(getContent() != null) {
            for (GachaContent gachaContent : getContent()) {
                clone.getContent().add(gachaContent.clone());
            }
        }

        clone.setProperties(getProperties());
        clone.setLimit(getLimit());
        clone.setUnique(isUnique());

        return clone;
    }
    
    public void populateValues(Item item) {
        setName(item.getName());
        setType(item.getType());
        setGacha(item.isGacha());
        setContent(item.getContent());
        setAllowDuplicates(item.doesAllowDuplicates());
        setShouldReroll(item.shouldReroll());
        setDuplicateReward(item.getDuplicateReward());
        setDisplayName(item.getDisplayName());
        setDisplayDescription(item.getDisplayDescription());
        setImageUrl(item.getImageUrl());
        setLimit(item.getLimit());
        setProperties(item.getProperties());
        setUnique(item.isUnique());
    }
}
