package io.gamedock.sdk.models.userdata;


import java.util.ArrayList;

import io.gamedock.sdk.models.userdata.gamestate.GameState;
import io.gamedock.sdk.models.userdata.inventory.Inventory;
import io.gamedock.sdk.models.userdata.inventory.PlayerItem;
import io.gamedock.sdk.models.userdata.inventory.UniquePlayerItem;
import io.gamedock.sdk.models.userdata.mission.MissionData;
import io.gamedock.sdk.models.userdata.wallet.PlayerCurrency;
import io.gamedock.sdk.models.userdata.wallet.Wallet;

public class UserData {

    private String userID;
    private String provider;

    public boolean updated = false;

    private GameState publicGameState;
    private GameState privateGameState;

    private Wallet wallet;
    private Inventory inventory;

    private MissionData missionData;

    private ArrayList<UserDataVersion> userDataVersions = new ArrayList<>();
    private UserDataMeta userDataMeta;

    public String getUserID() {
        return userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public String getProvider() {
        return provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public GameState getPublicGameState() {
        return publicGameState;
    }

    public void setPublicGameState(GameState publicGameState) {
        this.publicGameState = publicGameState;
    }

    public GameState getPrivateGameState() {
        return privateGameState;
    }

    public void setPrivateGameState(GameState privateGameState) {
        this.privateGameState = privateGameState;
    }

    public Wallet getWallet() {
        return wallet;
    }

    public void setWallet(Wallet wallet) {
        this.wallet = wallet;
    }

    public Inventory getInventory() {
        return inventory;
    }

    public void setInventory(Inventory inventory) {
        this.inventory = inventory;
    }

    public MissionData getMissionData() {
        return missionData;
    }

    public void setMissionData(MissionData missionData) {
        this.missionData = missionData;
    }

    public ArrayList<UserDataVersion> getUserDataVersions() {
        return userDataVersions;
    }

    public void setUserDataVersions(ArrayList<UserDataVersion> userDataVersions) {
        this.userDataVersions = userDataVersions;
    }

    public UserDataMeta getUserDataMeta() {
        return userDataMeta;
    }

    public void setUserDataMeta(UserDataMeta userDataMeta) {
        this.userDataMeta = userDataMeta;
    }

    public void Build() {
        if (wallet != null) {

            for (PlayerCurrency currency : wallet.getCurrencies()) {
                wallet.getCurrenciesMap().put(currency.getId(), currency);
            }

            wallet.getCurrencies().clear();
        }

        if (inventory != null) {

            for (PlayerItem item : inventory.getItems()) {
                inventory.getItemsMap().put(item.getId(), item);
            }

            inventory.getItems().clear();

            for (UniquePlayerItem uniqueItem : inventory.getUniqueItems()) {
                inventory.getUniqueItemsMap().put(uniqueItem.getUniqueId(), uniqueItem);
            }

            inventory.getUniqueItems().clear();
        }
    }

    public UserData clone() {
        UserData clone = new UserData();

        clone.setUserID(userID);
        clone.setProvider(provider);

        clone.setPublicGameState(publicGameState != null ? publicGameState.clone() : null);
        clone.setPrivateGameState(privateGameState != null ? privateGameState.clone() : null);

        clone.setWallet(wallet != null ? wallet.clone() : null);
        clone.setInventory(inventory != null ? inventory.clone() : null);

        clone.setMissionData(missionData != null ? missionData.clone() : null);

        ArrayList<UserDataVersion> cloneUserDataVersions = new ArrayList<>(userDataVersions);
        clone.setUserDataVersions(cloneUserDataVersions);

        if(userDataMeta != null) {
            UserDataMeta cloneUserDataMeta = new UserDataMeta();
            cloneUserDataMeta.serverTime = userDataMeta.serverTime;
            cloneUserDataMeta.clientTime = userDataMeta.clientTime;
            cloneUserDataMeta.timezoneOffset = userDataMeta.timezoneOffset;
            cloneUserDataMeta.deviceModel = userDataMeta.deviceModel;
            cloneUserDataMeta.appVersion = userDataMeta.appVersion;

            clone.setUserDataMeta(cloneUserDataMeta);
        }

        return clone;
    }
}
