package io.gamedock.sdk.models.config;

import android.content.Context;

import java.util.ArrayList;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.utils.storage.StorageUtil;

public class Spil {

    public String appToken = "";
    public String subDomain = "";
    public ArrayList<PermissionDialogSettings> permissionDialogSettings = new ArrayList<>();
    public ArrayList<Permission> permissions = new ArrayList<>();
    public ArrayList<PrivacyPolicy> privacyPolicies = new ArrayList<>();
    public ArrayList<AgeGate> ageGates = new ArrayList<>();
    public boolean gzipCompression = false;
    public int compressionThreshold = 2000;

    public void setSubDomain(Context context, String spilSubdomain) {
        GamedockSDK.getInstance(context).getStorageUtil().putBoolean(StorageUtil.Keys.SpilSubdomainOverride, true);

        if (!spilSubdomain.equals("")) {
            spilSubdomain = spilSubdomain + ".";
        }

        this.subDomain = spilSubdomain;
        GamedockSDK.getInstance(context).getStorageUtil().putString(StorageUtil.Keys.SpilSubdomain, spilSubdomain);
    }

    public Permission getPermission(String requestedPermission) {
        for(Permission permission : permissions) {
            if(permission.permission.equals(requestedPermission)) {
                return permission;
            }
        }

        return null;
    }

    public PermissionDialogSettings getDefaultPermissionDialogSettings(){
        for(PermissionDialogSettings dialogSettings : permissionDialogSettings) {
            if(dialogSettings.locale.equals("en")){
                return dialogSettings;
            }
        }

        return null;
    }

    public PrivacyPolicy getDefaultEnglishPrivacyPolicy(){
        for(PrivacyPolicy privacyPolicy : privacyPolicies) {
            if(privacyPolicy.locale.equals("en")){
                return privacyPolicy;
            }
        }

        return null;
    }

    public AgeGate getDefaultEnglishAgeGate(){
        for(AgeGate ageGate : ageGates) {
            if(ageGate.locale.equals("en")){
                return ageGate;
            }
        }

        return null;
    }
}
