package io.gamedock.sdk.initialization;

import java.util.HashMap;

import io.gamedock.sdk.BuildConfig;
import io.gamedock.sdk.GamedockEnvironment;
import io.gamedock.sdk.ads.MoreAppsCallbacks;
import io.gamedock.sdk.assetbundles.AssetBundlesCallbacks;
import io.gamedock.sdk.config.ConfigDataCallbacks;
import io.gamedock.sdk.dailybonus.DailyBonusCallbacks;
import io.gamedock.sdk.gamedata.GamedockGameDataCallbacks;
import io.gamedock.sdk.gamedata.packages.PackagesCallbacks;
import io.gamedock.sdk.gamedata.promotions.PromotionsCallbacks;
import io.gamedock.sdk.google.dynamiclinks.DeepLinkCallbacks;
import io.gamedock.sdk.localization.LocalizationCallbacks;
import io.gamedock.sdk.mission.MissionConfigurationCallbacks;
import io.gamedock.sdk.reward.RewardCallbacks;
import io.gamedock.sdk.social.SocialCallbacks;
import io.gamedock.sdk.splashscreen.SplashScreenCallbacks;
import io.gamedock.sdk.tier.TieredEventsCallbacks;
import io.gamedock.sdk.userdata.UserDataCallbacks;
import io.gamedock.sdk.utils.IAP.IAPCallbacks;
import io.gamedock.sdk.utils.agegate.AgeGateCallbacks;
import io.gamedock.sdk.utils.images.ImageLoadCallbacks;
import io.gamedock.sdk.utils.permissions.PermissionCallbacks;
import io.gamedock.sdk.utils.privacy.PrivacyPolicyCallbacks;
import io.gamedock.sdk.utils.server.ServerDataCallbacks;

public class InitializationOptions {
    private boolean withAgeGate;
    private boolean autoProcessAgeGate;
    private AgeGateOptions ageGateOptions;
    private boolean withPrivacyPolicy;
    private boolean autoProcessPrivacyPolicy;
    private boolean isCoppaEnabled;
    private HashMap<String, String> externalIds;

    private String store;
    private GamedockEnvironment environment;
    private String pluginName;
    private String pluginVersion;

    private InitializationDataCallbacks initializationDataCallbacks;
    private MoreAppsCallbacks moreAppsCallbacks;
    private GamedockGameDataCallbacks gamedockGameDataCallbacks;
    private UserDataCallbacks userDataCallbacks;
    private MissionConfigurationCallbacks missionConfigurationCallbacks;
    private RewardCallbacks rewardCallbacks;
    private ConfigDataCallbacks configDataCallbacks;
    private SplashScreenCallbacks splashScreenCallbacks;
    private DailyBonusCallbacks dailyBonusCallbacks;
    private ImageLoadCallbacks imageLoadCallbacks;
    private IAPCallbacks iapCallbacks;
    private ServerDataCallbacks serverDataCallbacks;
    private PermissionCallbacks permissionCallbacks;
    private SocialCallbacks socialCallbacks;
    private AgeGateCallbacks ageGateCallbacks;
    private PrivacyPolicyCallbacks privacyPolicyCallbacks;
    private PackagesCallbacks packagesCallbacks;
    private PromotionsCallbacks promotionsCallbacks;
    private TieredEventsCallbacks tieredEventsCallbacks;
    private AssetBundlesCallbacks assetBundlesCallbacks;
    private DeepLinkCallbacks deepLinkCallbacks;
    private LocalizationCallbacks localizationCallbacks;

    public InitializationOptions(Builder initOptionsBuilder) {
        this.withAgeGate = initOptionsBuilder.withAgeGate;
        this.autoProcessAgeGate = initOptionsBuilder.autoProcessAgeGate;
        this.ageGateOptions = initOptionsBuilder.ageGateOptions;
        this.withPrivacyPolicy = initOptionsBuilder.withPrivacyPolicy;
        this.autoProcessPrivacyPolicy = initOptionsBuilder.autoProcessPrivacyPolicy;
        this.isCoppaEnabled = initOptionsBuilder.isCoppaEnabled;
        this.externalIds = initOptionsBuilder.externalIds;

        this.store = initOptionsBuilder.store;
        this.environment = initOptionsBuilder.environment;
        this.pluginName = initOptionsBuilder.pluginName;
        this.pluginVersion = initOptionsBuilder.pluginVersion;

        this.initializationDataCallbacks = initOptionsBuilder.initializationDataCallbacks;
        this.moreAppsCallbacks = initOptionsBuilder.moreAppsCallbacks;
        this.gamedockGameDataCallbacks = initOptionsBuilder.gamedockGameDataCallbacks;
        this.userDataCallbacks = initOptionsBuilder.userDataCallbacks;
        this.missionConfigurationCallbacks = initOptionsBuilder.missionConfigurationCallbacks;
        this.rewardCallbacks = initOptionsBuilder.rewardCallbacks;
        this.configDataCallbacks = initOptionsBuilder.configDataCallbacks;
        this.splashScreenCallbacks = initOptionsBuilder.splashScreenCallbacks;
        this.dailyBonusCallbacks = initOptionsBuilder.dailyBonusCallbacks;
        this.imageLoadCallbacks = initOptionsBuilder.imageLoadCallbacks;
        this.iapCallbacks = initOptionsBuilder.iapCallbacks;
        this.serverDataCallbacks = initOptionsBuilder.serverDataCallbacks;
        this.permissionCallbacks = initOptionsBuilder.permissionCallbacks;
        this.socialCallbacks = initOptionsBuilder.socialCallbacks;
        this.ageGateCallbacks = initOptionsBuilder.ageGateCallbacks;
        this.privacyPolicyCallbacks = initOptionsBuilder.privacyPolicyCallbacks;
        this.packagesCallbacks = initOptionsBuilder.packagesCallbacks;
        this.promotionsCallbacks = initOptionsBuilder.promotionsCallbacks;
        this.tieredEventsCallbacks = initOptionsBuilder.tieredEventsCallbacks;
        this.assetBundlesCallbacks = initOptionsBuilder.assetBundlesCallbacks;
        this.deepLinkCallbacks = initOptionsBuilder.deepLinkCallbacks;
        this.localizationCallbacks = initOptionsBuilder.localizationCallbacks;
    }

    public boolean isWithAgeGate() {
        return withAgeGate;
    }

    public boolean isWithAutoProcessAgeGate() {
        return autoProcessAgeGate;
    }

    public AgeGateOptions getAgeGateOptions() {
        return ageGateOptions;
    }

    public boolean isWithPrivacyPolicy() {
        return withPrivacyPolicy;
    }

    public boolean isWithAutoProcessPrivacyPolicy() {
        return autoProcessPrivacyPolicy;
    }

    public boolean isCoppaEnabled() {
        return isCoppaEnabled;
    }

    public HashMap<String, String> getExternalIds() {
        return externalIds;
    }

    public String getStore() {
        return store;
    }

    public GamedockEnvironment getEnvironment() {
        return environment;
    }

    public String getPluginName() {
        return pluginName;
    }

    public String getPluginVersion() {
        return pluginVersion;
    }

    public InitializationDataCallbacks getInitializationDataCallbacks() {
        return initializationDataCallbacks;
    }

    public MoreAppsCallbacks getMoreAppsCallbacks() {
        return moreAppsCallbacks;
    }

    public GamedockGameDataCallbacks getGamedockGameDataCallbacks() {
        return gamedockGameDataCallbacks;
    }

    public UserDataCallbacks getUserDataCallbacks() {
        return userDataCallbacks;
    }

    public MissionConfigurationCallbacks getMissionConfigurationCallbacks() {
        return missionConfigurationCallbacks;
    }

    public RewardCallbacks getRewardCallbacks() {
        return rewardCallbacks;
    }

    public ConfigDataCallbacks getConfigDataCallbacks() {
        return configDataCallbacks;
    }

    public SplashScreenCallbacks getSplashScreenCallbacks() {
        return splashScreenCallbacks;
    }

    public DailyBonusCallbacks getDailyBonusCallbacks() {
        return dailyBonusCallbacks;
    }

    public ImageLoadCallbacks getImageLoadCallbacks() {
        return imageLoadCallbacks;
    }

    public IAPCallbacks getIapCallbacks() {
        return iapCallbacks;
    }

    public ServerDataCallbacks getServerDataCallbacks() {
        return serverDataCallbacks;
    }

    public PermissionCallbacks getPermissionCallbacks() {
        return permissionCallbacks;
    }

    public SocialCallbacks getSocialCallbacks() {
        return socialCallbacks;
    }

    public AgeGateCallbacks getAgeGateCallbacks() {
        return ageGateCallbacks;
    }

    public PrivacyPolicyCallbacks getPrivacyPolicyCallbacks() {
        return privacyPolicyCallbacks;
    }

    public PackagesCallbacks getPackagesCallbacks() {
        return packagesCallbacks;
    }

    public PromotionsCallbacks getPromotionsCallbacks() {
        return promotionsCallbacks;
    }

    public TieredEventsCallbacks getTieredEventsCallbacks() {
        return tieredEventsCallbacks;
    }

    public AssetBundlesCallbacks getAssetBundlesCallbacks() {
        return assetBundlesCallbacks;
    }

    public DeepLinkCallbacks getDeepLinkCallbacks() {
        return deepLinkCallbacks;
    }

    public LocalizationCallbacks getLocalizationCallbacks() {
        return localizationCallbacks;
    }

    public static class Builder {
        private boolean withAgeGate;
        private boolean autoProcessAgeGate;
        private AgeGateOptions ageGateOptions;
        private boolean withPrivacyPolicy;
        private boolean autoProcessPrivacyPolicy;
        private boolean isCoppaEnabled;
        private HashMap<String, String> externalIds = new HashMap<>();

        private String store = Builder.GooglePlay;
        private GamedockEnvironment environment = GamedockEnvironment.PRODUCTION;
        private String pluginName = "Native";
        private String pluginVersion = BuildConfig.VERSION_NAME;

        private InitializationDataCallbacks initializationDataCallbacks;
        private MoreAppsCallbacks moreAppsCallbacks;
        private GamedockGameDataCallbacks gamedockGameDataCallbacks;
        private UserDataCallbacks userDataCallbacks;
        private MissionConfigurationCallbacks missionConfigurationCallbacks;
        private RewardCallbacks rewardCallbacks;
        private ConfigDataCallbacks configDataCallbacks;
        private SplashScreenCallbacks splashScreenCallbacks;
        private DailyBonusCallbacks dailyBonusCallbacks;
        private ImageLoadCallbacks imageLoadCallbacks;
        private IAPCallbacks iapCallbacks;
        private ServerDataCallbacks serverDataCallbacks;
        private PermissionCallbacks permissionCallbacks;
        private SocialCallbacks socialCallbacks;
        private AgeGateCallbacks ageGateCallbacks;
        private PrivacyPolicyCallbacks privacyPolicyCallbacks;
        private PackagesCallbacks packagesCallbacks;
        private PromotionsCallbacks promotionsCallbacks;
        private TieredEventsCallbacks tieredEventsCallbacks;
        private AssetBundlesCallbacks assetBundlesCallbacks;
        private DeepLinkCallbacks deepLinkCallbacks;
        private LocalizationCallbacks localizationCallbacks;

        public static final String GooglePlay = "GooglePlay";
        public static final String Amazon = "Amazon";

        public Builder() {

        }

        public Builder setWithAgeGate(boolean withAgeGate, AgeGateOptions ageGateOptions) {
            this.withAgeGate = withAgeGate;
            this.ageGateOptions = ageGateOptions;
            return this;
        }

        public Builder setAutoProcessAgeGate(boolean autoProcessAgeGate) {
            this.autoProcessAgeGate = autoProcessAgeGate;
            return this;
        }

        public Builder setWithPrivacyPolicy(boolean withPrivacyPolicy) {
            this.withPrivacyPolicy = withPrivacyPolicy;
            return this;
        }

        public Builder setAutoProcessPrivacyPolicy(boolean autoProcessPrivacyPolicy) {
            this.autoProcessPrivacyPolicy = autoProcessPrivacyPolicy;
            return this;
        }

        public Builder isCoppaEnabled(boolean isCoppaEnabled) {
            this.isCoppaEnabled = isCoppaEnabled;
            return this;
        }

        public Builder setExternalIds(HashMap<String, String> externalIds) {
            this.externalIds = externalIds;
            return this;
        }

        public Builder setStore(String store) {
            this.store = store;
            return this;
        }

        public Builder setEnvironment(GamedockEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public Builder setPluginInformation(String pluginName, String pluginVersion) {
            this.pluginName = pluginName;
            this.pluginVersion = pluginVersion;
            return this;
        }

        public Builder setInitializationCallbacks(InitializationDataCallbacks initializationCallbacks) {
            this.initializationDataCallbacks = initializationCallbacks;
            return this;
        }

        public Builder setMoreAppsCallbacks(MoreAppsCallbacks moreAppsCallbacks) {
            this.moreAppsCallbacks = moreAppsCallbacks;
            return this;
        }

        public Builder setGamedockGameDataCallbacks(GamedockGameDataCallbacks gamedockGameDataCallbacks) {
            this.gamedockGameDataCallbacks = gamedockGameDataCallbacks;
            return this;
        }

        public Builder setUserDataCallbacks(UserDataCallbacks userDataCallbacks) {
            this.userDataCallbacks = userDataCallbacks;
            return this;
        }

        public Builder setMissionConfigurationCallbacks(MissionConfigurationCallbacks missionConfigurationCallbacks) {
            this.missionConfigurationCallbacks = missionConfigurationCallbacks;
            return this;
        }

        public Builder setRewardCallbacks(RewardCallbacks rewardCallbacks) {
            this.rewardCallbacks = rewardCallbacks;
            return this;
        }

        public Builder setConfigDataCallbacks(ConfigDataCallbacks configDataCallbacks) {
            this.configDataCallbacks = configDataCallbacks;
            return this;
        }

        public Builder setSplashScreenCallbacks(SplashScreenCallbacks splashScreenCallbacks) {
            this.splashScreenCallbacks = splashScreenCallbacks;
            return this;
        }

        public Builder setDailyBonusCallbacks(DailyBonusCallbacks dailyBonusCallbacks) {
            this.dailyBonusCallbacks = dailyBonusCallbacks;
            return this;
        }

        public Builder setImageLoadCallbacks(ImageLoadCallbacks imageLoadCallbacks) {
            this.imageLoadCallbacks = imageLoadCallbacks;
            return this;
        }

        public Builder setIapCallbacks(IAPCallbacks iapCallbacks) {
            this.iapCallbacks = iapCallbacks;
            return this;
        }

        public Builder setServerDataCallbacks(ServerDataCallbacks serverDataCallbacks) {
            this.serverDataCallbacks = serverDataCallbacks;
            return this;
        }

        public Builder setPermissionCallbacks(PermissionCallbacks permissionCallbacks) {
            this.permissionCallbacks = permissionCallbacks;
            return this;
        }

        public Builder setSocialCallbacks(SocialCallbacks socialCallbacks) {
            this.socialCallbacks = socialCallbacks;
            return this;
        }

        public Builder setAgeGateCallbacks(AgeGateCallbacks ageGateCallbacks) {
            this.ageGateCallbacks = ageGateCallbacks;
            return this;
        }

        public Builder setPrivacyPolicyCallbacks(PrivacyPolicyCallbacks privacyPolicyCallbacks) {
            this.privacyPolicyCallbacks = privacyPolicyCallbacks;
            return this;
        }

        public Builder setPackagesCallbacks(PackagesCallbacks packagesCallbacks) {
            this.packagesCallbacks = packagesCallbacks;
            return this;
        }

        public Builder setPromotionsCallbacks(PromotionsCallbacks promotionsCallbacks) {
            this.promotionsCallbacks = promotionsCallbacks;
            return this;
        }

        public Builder setTieredEventsCallbacks(TieredEventsCallbacks tieredEventsCallbacks) {
            this.tieredEventsCallbacks = tieredEventsCallbacks;
            return this;
        }

        public Builder setAssetBundlesCallbacks(AssetBundlesCallbacks assetBundlesCallbacks) {
            this.assetBundlesCallbacks = assetBundlesCallbacks;
            return this;
        }

        public Builder setDeepLinkCallbacks(DeepLinkCallbacks deepLinkCallbacks) {
            this.deepLinkCallbacks = deepLinkCallbacks;
            return this;
        }

        public Builder setLocalizationCallbacks(LocalizationCallbacks localizationCallbacks) {
            this.localizationCallbacks = localizationCallbacks;
            return this;
        }

        public InitializationOptions build() {
            return new InitializationOptions(this);
        }
    }

    public static class AgeGateOptions {
        public boolean shouldBlock;
        public int requiredAge;

        public AgeGateOptions(boolean shouldBlock, int requiredAge) {
            this.shouldBlock = shouldBlock;
            this.requiredAge = requiredAge;
        }
    }
}
