package io.gamedock.sdk.gamedata.packages;


import com.unity3d.player.UnityPlayer;

import io.gamedock.sdk.utils.logging.LoggingUtil;

/**
 * Class that handles the Packages Callbacks.
 * Notifies the application when the Packages configuration has been received and processed by the SDK.
 */
public class PackagesCallbacks {

    private OnPackageListener packageListener;

    public PackagesCallbacks() {
        packageListener = null;
    }

    public PackagesCallbacks(OnPackageListener packageListener) {
        this.packageListener = packageListener;
    }

    /**
     * Method that is called when the Packages configuration has been process and is available to be retrieved.
     */
    public void packagesAvailable(String packagesJSON) {
        if (packageListener != null) {
            packageListener.PackagesAvailable(packagesJSON);
        } else {
            try {
                UnityPlayer.UnitySendMessage("GamedockSDK", "PackagesAvailable", packagesJSON);
            } catch (NoClassDefFoundError e) {
                LoggingUtil.w("Tried to send information to Unity but UnityPlayer could not be found (NoClassDefFoundError). This can happen by design and is not necessarily a problem.");
            }
        }
    }

    /**
     * Method that is called when the Packages configuration is not available.
     */
    public void packagesNotAvailable() {
        if (packageListener != null) {
            packageListener.PackagesNotAvailable();
        } else {
            try {
                UnityPlayer.UnitySendMessage("GamedockSDK", "PackagesNotAvailable", "");
            } catch (NoClassDefFoundError e) {
                LoggingUtil.w("Tried to send information to Unity but UnityPlayer could not be found (NoClassDefFoundError). This can happen by design and is not necessarily a problem.");
            }
        }
    }

}
