package io.gamedock.sdk.events.response;

import android.content.Context;
import android.content.Intent;

import org.json.JSONException;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.tier.TieredEventsManager;
import io.gamedock.sdk.utils.error.ErrorCodes;
import io.gamedock.sdk.utils.logging.LoggingUtil;
import io.gamedock.sdk.web.WebViewActivity;

/**
 * Class that processes information regarding tiered events feature responses.
 */
public class TieredResponseEvent extends ResponseEvent {

    TieredResponseEvent(ResponseEvent responseEvent) {
        super();

        try {
            setName(responseEvent.getName());
            setType(responseEvent.getType());
            setAction(responseEvent.getAction());
            this.responseData = responseEvent.responseData;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processData(Context context) {
        LoggingUtil.d("Processing data for TieredResponseEvent");

        String action = getAction().toLowerCase().trim();

        switch (action) {
            case "request":
                TieredEventsManager.getInstance(context).processRequestTieredEvent(responseData);
                break;
            case "update":
                TieredEventsManager.getInstance(context).processUpdateTierProgress(responseData);
                break;
            case "claim":
                TieredEventsManager.getInstance(context).processClaimTierReward(responseData);
                break;
            case "show":
                try {
                    GamedockSDK.getInstance(context).isShowingChildActivity = true;

                    Intent intent = new Intent(context, WebViewActivity.class);
                    intent.putExtra("webViewUrl", responseData.getString("url"));
                    intent.putExtra("eventName", getName());
                    intent.putExtra("eventData", responseData.toString());
                    intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                    context.startActivity(intent);
                } catch (JSONException | NullPointerException e) {
                    e.printStackTrace();
                }
                break;
            case "notavailable":
                GamedockSDK.getInstance(context).getTieredEventCallbacks().tieredEventsNotAvailable();
                break;
            case "error":
                if (getName().contains("claimTierReward")) {
                    GamedockSDK.getInstance(context).getTieredEventCallbacks().tieredEventsError(ErrorCodes.TieredEventClaimTierError);
                    if (WebViewActivity.getActivity() != null) {
                        WebViewActivity.getActivity().javascriptBridge.nativeMessage("claimTierReward", responseData.toString());
                    }
                } else if (getName().contains("showTieredEventProgress")) {
                    GamedockSDK.getInstance(context).getTieredEventCallbacks().tieredEventsError(ErrorCodes.TieredEventShowProgressError);
                } else if (getName().contains("updateTieredEventProgress")) {
                    GamedockSDK.getInstance(context).getTieredEventCallbacks().tieredEventsError(ErrorCodes.TieredEventUpdateProgressError);
                }
                break;
        }
    }

}
