package io.gamedock.sdk.events.response;

import android.content.Context;

import io.gamedock.sdk.social.SocialManager;
import io.gamedock.sdk.utils.logging.LoggingUtil;

/**
 * Class that processes information regarding social login responses.
 */
public class SocialLoginResponseEvent extends ResponseEvent {

    private String socialLoginJSON;

    SocialLoginResponseEvent(ResponseEvent responseEvent) {
        super();

        try {
            if (responseEvent.responseData != null) {
                this.socialLoginJSON = responseEvent.responseData.toString();
            }

            setName(responseEvent.getName());
            setType(responseEvent.getType());
            setAction(responseEvent.getAction());
            this.responseData = responseEvent.responseData;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processData(Context context) {
        LoggingUtil.d("Processing data for SocialLoginResponseEvent");

        String action = getAction().toLowerCase().trim();

        switch (action) {
            case "register":
                SocialManager.getInstance(context).processUserRegister(socialLoginJSON);
                break;
            case "login":
                SocialManager.getInstance(context).processUserLogin(socialLoginJSON);
                break;
            case "logout":
                SocialManager.getInstance(context).processUserLogout();
                break;
            case "error":
                SocialManager.getInstance(context).processUserLoginError(socialLoginJSON);
                break;
        }
    }
}
