package io.gamedock.sdk.events.response;


import android.content.Context;

import com.google.gson.Gson;

import org.json.JSONArray;

import java.util.HashMap;

import io.gamedock.sdk.gamedata.promotions.PromotionsManager;
import io.gamedock.sdk.models.gamedata.promotion.Promotion;
import io.gamedock.sdk.utils.logging.LoggingUtil;

/**
 * Class that processes information regarding promotions configuration responses.
 */
public class PromotionsResponseEvent extends ResponseEvent {

    private HashMap<Integer, Promotion> promotions = null;
    private Promotion boughtPromotion = null;

    PromotionsResponseEvent(ResponseEvent responseEvent) {
        super();

        LoggingUtil.d("Received Promotion Data: " + responseEvent.toJSONString(false));

        try {
            Gson gson = new Gson();
            if (responseEvent.getAction().equals("request")) {
                if (responseEvent.responseData.has("promotions")) {
                    promotions = new HashMap<>();

                    JSONArray promotionJSON = responseEvent.responseData.getJSONArray("promotions");

                    for (int i = 0; i < promotionJSON.length(); i++) {
                        Promotion promotion = gson.fromJson(promotionJSON.getJSONObject(i).toString(), Promotion.class);
                        promotions.put(promotion.getId(), promotion);
                    }
                }
            } else if (responseEvent.getAction().equals("update")) {
                boughtPromotion = new Promotion();
                if (responseEvent.responseData.has("id")) {
                    boughtPromotion.setId(responseEvent.responseData.getInt("id"));
                }

                if (responseEvent.responseData.has("amountPurchased")) {
                    boughtPromotion.setAmountPurchased(responseEvent.responseData.getInt("amountPurchased"));
                }

                if (responseEvent.responseData.has("maxPurchase")) {
                    boughtPromotion.setMaxPurchase(responseEvent.responseData.getInt("maxPurchase"));
                }
            }

            setName(responseEvent.getName());
            setType(responseEvent.getType());
            setAction(responseEvent.getAction());
            setMessage(responseEvent.getMessage());
            this.responseData = responseEvent.responseData;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processData(Context context) {
        LoggingUtil.d("Processing data for PromotionsResponseEvent");

        String action = getAction().toLowerCase().trim();

        if (action.equals("request")) {
            PromotionsManager.getInstance(context).processPromotions(promotions);
        } else if (action.equals("update")) {
            PromotionsManager.getInstance(context).processBoughtPromotionResponse(boughtPromotion);
        }

    }
}
