package io.gamedock.sdk.events.response;

import android.content.Context;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.ads.internal.GamedockMoreAppsManager;
import io.gamedock.sdk.models.ads.internal.GamedockMoreAppsObject;
import io.gamedock.sdk.utils.logging.LoggingUtil;

/**
 * Class that processes information regarding the more apps configuration response.
 */
public class MoreAppsResponseEvent extends ResponseEvent {

    private GamedockMoreAppsObject gamedockMoreAppsObject = null;

    MoreAppsResponseEvent(ResponseEvent responseEvent) {
        super();

        try {
            if (responseEvent.getAction().toLowerCase().trim().equals("request")) {
                gamedockMoreAppsObject = new GamedockMoreAppsObject();

                if (responseEvent.responseData.has("url")) {
                    gamedockMoreAppsObject.url = responseEvent.responseData.getString("url");
                }

                gamedockMoreAppsObject.data = responseEvent.responseData;
            }

            setName(responseEvent.getName());
            setType(responseEvent.getType());
            setAction(responseEvent.getAction());
            this.responseData = responseEvent.responseData;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processData(Context context) {
        LoggingUtil.d("Processing data for MoreAppsResponseEvent");

        if (gamedockMoreAppsObject != null) {
            GamedockMoreAppsManager.getInstance().processSpilMoreApps(context, gamedockMoreAppsObject);
        } else {
            GamedockSDK.getInstance(context).getMoreAppsCallbacks().MoreAppsNotAvailable("moreApps");
        }
    }
}
