package io.gamedock.sdk.events.response;

import android.content.Context;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

import org.json.JSONArray;

import java.util.ArrayList;

import io.gamedock.sdk.mission.MissionConfigurationManager;
import io.gamedock.sdk.models.mission.Container;
import io.gamedock.sdk.models.mission.Mission;
import io.gamedock.sdk.utils.logging.LoggingUtil;

/**
 * Class that processes information regarding the mission configuration response.
 */
public class MissionResponseEvent extends ResponseEvent {

    private ArrayList<Container> receivedContainers = null;
    private ArrayList<Mission> receivedMissions = null;

    MissionResponseEvent(ResponseEvent responseEvent) {
        super();

        try {
            Gson gson = new Gson();
            if (responseEvent.responseData.has("containers")) {
                receivedContainers = new ArrayList<>();
                JSONArray containersJSON = responseEvent.responseData.getJSONArray("containers");
                JsonParser jsonParser = new JsonParser();
                for (int i = 0; i < containersJSON.length(); i++) {
                    Container container = gson.fromJson(containersJSON.getJSONObject(i).toString(), Container.class);
                    if (containersJSON.getJSONObject(i).has("properties")) {
                        JsonObject properties = (JsonObject) jsonParser.parse(containersJSON.getJSONObject(i).getJSONObject("properties").toString());
                        container.setProperties(properties);
                    }
                    receivedContainers.add(container);
                }
            }

            if (responseEvent.responseData.has("missions")) {
                receivedMissions = new ArrayList<>();
                JSONArray missionsJSON = responseEvent.responseData.getJSONArray("missions");
                JsonParser jsonParser = new JsonParser();
                for (int i = 0; i < missionsJSON.length(); i++) {
                    Mission mission = gson.fromJson(missionsJSON.getJSONObject(i).toString(), Mission.class);

                    if (missionsJSON.getJSONObject(i).has("properties")) {
                        JsonObject properties = (JsonObject) jsonParser.parse(missionsJSON.getJSONObject(i).getJSONObject("properties").toString());
                        mission.setProperties(properties);
                    }

                    if (missionsJSON.getJSONObject(i).has("gamePrerequisites")) {
                        JsonObject gamePrerequisites = (JsonObject) jsonParser.parse(missionsJSON.getJSONObject(i).getJSONObject("gamePrerequisites").toString());
                        mission.setGamePrerequisites(gamePrerequisites);
                    }

                    if (missionsJSON.getJSONObject(i).has("gameUnlocks")) {
                        JsonObject gameUnlocks = (JsonObject) jsonParser.parse(missionsJSON.getJSONObject(i).getJSONObject("gameUnlocks").toString());
                        mission.setGameUnlocks(gameUnlocks);
                    }

                    JSONArray objectivesJSON = missionsJSON.getJSONObject(i).getJSONArray("objectives");
                    for (int j = 0; j < objectivesJSON.length(); j++) {
                        JsonObject objectiveDataJSON = (JsonObject) jsonParser.parse(objectivesJSON.getJSONObject(j).getJSONObject("data").toString());
                        mission.getObjectives().get(j).setData(objectiveDataJSON);
                    }

                    receivedMissions.add(mission);
                }
            }

            setName(responseEvent.getName());
            setType(responseEvent.getType());
            setAction(responseEvent.getAction());
            this.responseData = responseEvent.responseData;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processData(Context context) {
        LoggingUtil.d("Processing data for GameDataResponseEvent");

        if (getAction().equals("request")) {
            MissionConfigurationManager.getInstance(context).processMissionConfig(receivedContainers, receivedMissions);
        }
    }

    public ArrayList<Container> getReceivedContainers() {
        return receivedContainers;
    }

    public ArrayList<Mission> getReceivedMissions() {
        return receivedMissions;
    }
}
