package io.gamedock.sdk.events.response;

import android.content.Context;

import org.json.JSONArray;
import org.json.JSONObject;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.initialization.InitializationManager;
import io.gamedock.sdk.utils.logging.LoggingUtil;

/**
 * Class that processes information regarding the sdk initialisation response.
 * Contains the user id change request received from the backend and the game version update information (forced or recommended).
 */
public class InitializeSDKResponseEvent extends ResponseEvent {

    JSONObject uidChange;
    JSONObject gameVersion;
    JSONArray features;
    JSONArray whitelistedEvents;

    InitializeSDKResponseEvent(ResponseEvent responseEvent) {
        super();

        try {
            if (responseEvent.responseData != null) {
                if (responseEvent.getAction().equals("initialize")) {
                    if (responseEvent.responseData.has("features")) {
                        features = responseEvent.responseData.getJSONArray("features");
                    }

                    if (responseEvent.responseData.has("uidChange")) {
                        uidChange = responseEvent.responseData.getJSONObject("uidChange");
                    }

                    if (responseEvent.responseData.has("gameVersion")) {
                        gameVersion = responseEvent.responseData.getJSONObject("gameVersion");
                    }

                    if (responseEvent.responseData.has("whitelistedEvents")) {
                        whitelistedEvents = responseEvent.responseData.getJSONArray("whitelistedEvents");
                    }
                }
            }

            setName(responseEvent.getName());
            setType(responseEvent.getType());
            setAction(responseEvent.getAction());
            this.responseData = responseEvent.responseData;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processData(Context context) {
        LoggingUtil.d("Processing data for ConfigResponseEvent");

        if (features != null) {
            InitializationManager.processFeaturesInitialisation(context, features);
        }

        if (uidChange != null) {
            InitializationManager.processUidChange(context, uidChange);
        }

        if (gameVersion != null) {
            InitializationManager.processGameVersionStatus(context, gameVersion);
        }

        if (whitelistedEvents != null) {
            InitializationManager.processWhitelistedEvents(context, whitelistedEvents);
        }

        GamedockSDK.getInstance(context).initFeatures();
    }

    public JSONObject getUidChange() {
        return uidChange;
    }

    public JSONObject getGameVersion() {
        return gameVersion;
    }
}
