package io.gamedock.sdk.events.response;

import android.content.Context;

import io.gamedock.sdk.userdata.UserDataManager;
import io.gamedock.sdk.utils.logging.LoggingUtil;

/**
 * Class that processes information regarding game state responses.
 */
public class GameStateResponseEvent extends ResponseEvent {

    private String gameStateData;

    GameStateResponseEvent(ResponseEvent responseEvent) {
        super();

        try {
            if (responseEvent.responseData != null) {
                this.gameStateData = responseEvent.responseData.toString();
            }

            setName(responseEvent.getName());
            setType(responseEvent.getType());
            setAction(responseEvent.getAction());
            setMessage(responseEvent.getMessage());
            this.responseData = responseEvent.responseData;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processData(Context context) {
        LoggingUtil.d("Processing data for GameStateResponseEvent");

        String action = getAction().toLowerCase().trim();

        switch (action) {
            case "update":
                UserDataManager.getInstance(context).getGameStateManager().processMyGameStateResponse(gameStateData);
                break;
            case "otherusers":
                UserDataManager.getInstance(context).getGameStateManager().processOtherUsersGameStateResponse(gameStateData);
                break;
            case "syncerror":
                UserDataManager.getInstance(context).processSyncError();
                break;
            case "dropped":
                UserDataManager.getInstance(context).processDroppedResponse(getMessage());
                break;
            case "lockerror":
                UserDataManager.getInstance(context).processLockError();
                break;
        }
    }
}
