package io.gamedock.sdk.events.internal;

import android.content.Context;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.events.Event;
import io.gamedock.sdk.utils.error.ErrorCodes;

public class TierEvent extends Event{

    public static final String RequestTieredEvent = "requestTieredEvents";
    public static final String UpdateTierProgress = "updateTieredEventProgress";
    public static final String ClaimTierReward = "claimTierReward";
    public static final String ShowTierProgress = "showTieredEventProgress";

    public TierEvent(Context context) {
        super(context);
    }

    public void setRequestTieredEvent() {
        this.setName(RequestTieredEvent);
    }

    public void setUpdateTierProgress() {
        this.setName(UpdateTierProgress);
    }

    public void setClaimTierReward() {
        this.setName(ClaimTierReward);
    }

    public void setShowTierProgress() {
        this.setName(ShowTierProgress);
    }

    @Override
    public void handleNetworkError(Context context) {
        if (isNetworkErrorHandled()) {
            return;
        }

        switch (getName()) {
            case RequestTieredEvent:
                GamedockSDK.getInstance(context).getTieredEventCallbacks().tieredEventsNotAvailable();
                break;
            case UpdateTierProgress:
                GamedockSDK.getInstance(context).getTieredEventCallbacks().tieredEventsError(ErrorCodes.TieredEventUpdateProgressError);
                break;
            case ClaimTierReward:
                GamedockSDK.getInstance(context).getTieredEventCallbacks().tieredEventsError(ErrorCodes.TieredEventClaimTierError);
                break;
            case ShowTierProgress:
                GamedockSDK.getInstance(context).getTieredEventCallbacks().tieredEventsError(ErrorCodes.TieredEventShowProgressError);
                break;
        }

        setNetworkErrorHandled(true);
    }

}
