package io.gamedock.sdk.events.internal;

import android.content.Context;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.events.Event;
import io.gamedock.sdk.utils.error.ErrorCodes;

public class SocialLoginEvent extends Event{

    public static final String UserLogin = "userLogin";
    public static final String UserLogout = "userLogout";
    public static final String UserPlayAsGuest = "userPlayAsGuest";

    public SocialLoginEvent(Context context) {
        super(context);
    }

    public void setUserLogin() {
        this.setName(UserLogin);
    }

    public void setUserLogout() {
        this.setName(UserLogout);
    }

    public void setUserPlayAsGuest() {
        this.setName(UserPlayAsGuest);
    }

    @Override
    public void handleNetworkError(Context context) {
        if (isNetworkErrorHandled()) {
            return;
        }

        if(getName().equals(UserLogin)) {
            GamedockSDK.getInstance(context).getSocialCallbacks().LoginFailed(ErrorCodes.GamedockLoginServerError);
        } else if (getName().equals(UserLogout) && customData.has("global") && customData.get("global").getAsBoolean()) {
            GamedockSDK.getInstance(context).getSocialCallbacks().LogoutFailed(ErrorCodes.GamedockLoginServerError);
        }

        setNetworkErrorHandled(true);
    }

}
