package io.gamedock.sdk.events.internal;


import android.content.Context;

import io.gamedock.sdk.events.Event;
import io.gamedock.sdk.utils.device.NetworkUtil;

public class PromotionEvent extends Event {

    public static final String RequestPromotions = "requestPromotions";
    public static final String ShowPromotionScreen = "showPromotionScreen";
    public static final String BoughtPromotion = "boughtPromotion";

    public PromotionEvent(Context context) {
        super(context);
    }

    public void setRequestPromotions() {
        this.setName(RequestPromotions);
    }

    public void setShowPromotionScreen() {
        this.setName(ShowPromotionScreen);
    }

    public void setBoughtPromotion() {
        this.setName(BoughtPromotion);
    }

    @Override
    public void handleNetworkError(Context context) {
        if (isNetworkErrorHandled()) {
            return;
        }

        if (getName().equals(RequestPromotions) && NetworkUtil.isInternetAvailable(context)) {

        } else {

        }

        setNetworkErrorHandled(true);
    }

}
