package io.gamedock.sdk.events.internal;

import android.content.Context;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.events.Event;

public class MoreAppsEvent extends Event {

    public static final String RequestMoreApps = "requestMoreApps";

    public MoreAppsEvent(Context context) {
        super(context);
    }

    public void setRequestMoreApps() {
        this.setName(RequestMoreApps);
    }

    @Override
    public void handleNetworkError(Context context) {
        if (isNetworkErrorHandled()) {
            return;
        }

        GamedockSDK.getInstance(context).getMoreAppsCallbacks().MoreAppsNotAvailable("moreApps");

        setNetworkErrorHandled(true);
    }
}
