package io.gamedock.sdk.events.internal;

import android.content.Context;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.events.Event;
import io.gamedock.sdk.utils.device.NetworkUtil;
import io.gamedock.sdk.utils.error.ErrorCodes;

public class ConfigEvent extends Event {

    public static final String RequestConfig = "requestConfig";

    public ConfigEvent(Context context) {
        super(context);
    }

    public void setRequestConfig() {
        this.setName(RequestConfig);
    }

    @Override
    public void handleNetworkError(Context context) {
        if (isNetworkErrorHandled()) {
            return;
        }

        if(NetworkUtil.isInternetAvailable(context)) {
            GamedockSDK.getInstance(context).getConfigDataCallbacks().configError(ErrorCodes.ConfigServerError);
        } else {
            GamedockSDK.getInstance(context).getConfigDataCallbacks().configDataUpdated();
        }

        setNetworkErrorHandled(true);
    }
}
