package io.gamedock.sdk.ads;

import com.unity3d.player.UnityPlayer;

import org.json.JSONException;
import org.json.JSONObject;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.utils.logging.LoggingUtil;

/**
 * Class that handles the Ad Networks Callbacks.
 * Sends the different status that the ads going through: Available, Not Available, Started, Finished.
 * Handles the logic to create a circular progress bar before showing an ad.
 */
public class MoreAppsCallbacks {

    private OnAdsListener adsListener;

    public MoreAppsCallbacks() {
        adsListener = null;
    }

    public MoreAppsCallbacks(OnAdsListener adsListener) {
        this.adsListener = adsListener;
    }

    public void MoreAppsAvailable(String type) {
        if (this.adsListener != null) {
            this.adsListener.AdAvailable(type);
        } else {
            try {
                UnityPlayer.UnitySendMessage("GamedockSDK", "AdAvailable", type);
            } catch (NoClassDefFoundError e) {
                LoggingUtil.w("You need to register the OnAdsListener in order to receive information or something went wrong with Unity");
            }
        }
    }

    public void MoreAppsNotAvailable(String type) {
        LoggingUtil.d("AdNotAvailable Type: " + type);
        if (this.adsListener != null) {
            this.adsListener.AdNotAvailable(type);
        } else {
            try {
                UnityPlayer.UnitySendMessage("GamedockSDK", "AdNotAvailable", type);
            } catch (NoClassDefFoundError e) {
                LoggingUtil.w("You need to register the OnAdsListener in order to receive information or something went wrong with Unity");
            }
        }
    }

    public void MoreAppsStart(String type) {
        if (this.adsListener != null) {
            this.adsListener.AdStart(type);
        } else {
            try {
                UnityPlayer.UnitySendMessage("GamedockSDK", "AdStart", type);
            } catch (NoClassDefFoundError e) {
                LoggingUtil.w("Tried to send information to Unity but UnityPlayer could not be found (NoClassDefFoundError). This can happen by design and is not necessarily a problem.");
            }
        }
    }

    public void OnAdTrigger(String json) {
        if (this.adsListener != null) {
            this.adsListener.OnAdTrigger();
        } else {
            try {
                UnityPlayer.UnitySendMessage("GamedockSDK", "OnAdTrigger", json);

            } catch (NoClassDefFoundError e) {
                LoggingUtil.w("Tried to send information to Unity but UnityPlayer could not be found (NoClassDefFoundError). This can happen by design and is not necessarily a problem.");
            }
        }
    }

    public void MoreAppsFinished(String network, String adType, String reason) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("network", network);
            jsonObject.put("type", adType);
            jsonObject.put("reason", reason);
            if (this.adsListener != null) {
                this.adsListener.AdFinished(jsonObject.toString());
            } else {
                LoggingUtil.d("Sending AdFinished to Unity");
                UnityPlayer.UnitySendMessage("GamedockSDK", "AdFinished", jsonObject.toString());
            }
        } catch (NullPointerException | NoClassDefFoundError | JSONException e) {
            LoggingUtil.w("You need to register the OnAdsListener in order to receive information or something went wrong with Unity");
        }
    }
}
