package io.gamedock.sdk.ads;


import android.content.Context;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.events.Event;

/**
 * Class that handles all the internal events that are fired in regards to ads.
 * Handles events for interstitials, reward videos and more apps.
 */
public class AdEvents {

    public static final String AdvertisementInitialized = "advertisementInitialized";

    public static final String BannerRequested = "bannerRequested";
    public static final String BannerDidDisplay = "bannerDidDisplay";
    public static final String BannerDidNotDisplay = "bannerDidNotDisplay";
    public static final String BannerDidHide = "bannerDidHide";
    public static final String BannerDidClick = "bannerDidClick";
    public static final String BannerAvailable = "bannerAvailable";
    public static final String BannerNotAvailable = "bannerNotAvailable";
    public static final String BannerDidMonetize = "bannerDidMonetize";

    public static final String InterstitialRequested = "interstitialRequested";
    public static final String InterstitialDidClose = "interstitialDidClose";
    public static final String InterstitialDidDisplay = "interstitialDidDisplay";
    public static final String InterstitialDidClick = "interstitialDidClick";
    public static final String InterstitialAvailable = "interstitialAvailable";
    public static final String InterstitialNotAvailable = "interstitialNotAvailable";
    public static final String InterstitialDidNotDisplay = "interstitialDidNotDisplay";
    public static final String InterstitialDidMonetize = "interstitialDidMonetize";

    public static final String RewardedVideoRequested = "rewardedVideoRequested";
    public static final String RewardVideoDidClose = "rewardedVideoDidClose";
    public static final String RewardVideoDidDisplay = "rewardedVideoDidDisplay";
    public static final String RewardVideoDidDismiss = "rewardedVideoDidDismiss";
    public static final String RewardVideoAvailable = "rewardedVideoAvailable";
    public static final String RewardVideoNotAvailable = "rewardedVideoNotAvailable";
    public static final String RewardVideoDidNotDisplay = "rewardedVideoDidNotDisplay";
    public static final String RewardVideoDidClickPlay = "rewardedVideoDidClickPlay";
    public static final String RewardVideoDidClick = "rewardedVideoDidClick";
    public static final String RewardVideoDidMonetize = "rewardedVideoDidMonetize";

    private static final String MoreAppsDidClose = "moreAppsDidClose";
    private static final String MoreAppsDidDisplay = "moreAppsDidDisplay";
    private static final String MoreAppsDidClick = "moreAppsDidClick";

    /**
     * Method that creates an event for when more apps has been closed and sends it to the backend.
     *
     * @param context The activity context.
     */
    public static void moreAppsDidClose(Context context) {
        Event event = new Event(context);
        event.setName(MoreAppsDidClose);

        GamedockSDK.getInstance(context).trackEvent(event, null);
    }

    /**
     * Method that creates an event for when more apps has been displayed and sends it to the backend.
     *
     * @param context The activity context.
     */
    public static void moreAppsDidDisplay(Context context) {
        Event event = new Event(context);
        event.setName(MoreAppsDidDisplay);

        GamedockSDK.getInstance(context).trackEvent(event, null);
    }

    /**
     * Method that creates an event for when more apps has been clicked and sends it to the backend.
     *
     * @param context The activity context.
     */
    public static void moreAppsDidClick(Context context) {
        Event event = new Event(context);
        event.setName(MoreAppsDidClick);

        GamedockSDK.getInstance(context).trackEvent(event, null);
    }

}