package io.gamedock.sdk.utils.server;


import com.unity3d.player.UnityPlayer;

import org.json.JSONException;
import org.json.JSONObject;

import io.gamedock.sdk.utils.error.ErrorCodes;
import io.gamedock.sdk.utils.logging.LoggingUtil;

/**
 * Class that handles the Server Data Callbacks.
 * Notifies the application when the Server Data has been received and processed by the SDK.
 */
public class ServerDataCallbacks {

    private OnServerDataListener serverDataListener;

    public ServerDataCallbacks() {
        serverDataListener = null;
    }

    public ServerDataCallbacks(OnServerDataListener serverDataListener) {
        this.serverDataListener = serverDataListener;
    }

    /**
     * Method that is called when the server time has been updated been received by the SDK.
     */
    public void serverTimeRequestSuccess(long serverTime) {
        if (serverDataListener != null) {
            serverDataListener.ServerTimeRequestSuccess(serverTime);
        } else {
            try {
                UnityPlayer.UnitySendMessage("GamedockSDK", "ServerTimeRequestSuccess", String.valueOf(serverTime));
            } catch (NoClassDefFoundError e) {
                LoggingUtil.w("Tried to send information to Unity but UnityPlayer could not be found (NoClassDefFoundError). This can happen by design and is not necessarily a problem.");
            }
        }
    }

    /**
     * Method called when the server data retrieval failed.
     * @param error
     * The error with which the retrival has failed.
     */
    public void serverTimeRequestFailed(ErrorCodes error) {
        if (serverDataListener != null) {
            serverDataListener.ServerTimeRequestFailed(error);
        } else {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", error.getId());
                jsonObject.put("name", error.getName());
                jsonObject.put("message", error.getMessage());

                UnityPlayer.UnitySendMessage("GamedockSDK", "ServerTimeRequestFailed", jsonObject.toString());
            } catch (JSONException | NoClassDefFoundError e) {
                LoggingUtil.w("Tried to send information to Unity but UnityPlayer could not be found (NoClassDefFoundError). This can happen by design and is not necessarily a problem.");
            }
        }
    }
}
