package io.gamedock.sdk.utils.privacy;


import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;

import java.util.Locale;

import io.gamedock.sdk.R;
import io.gamedock.sdk.config.internal.GamedockConfigManager;
import io.gamedock.sdk.models.config.PrivacyPolicy;

public class PrivacyPolicyInfoFragment extends Fragment {

    private OnPrivacyPolicyInfoListener onPrivacyPolicyInfoListener;

    private ImageView privacyPolicyImage;

    private TextView privacyPolicyInfoDescription;

    private Button privacyPolicyInfoOkButton;

    public PrivacyPolicyInfoFragment() {
        // Required empty public constructor
    }


    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_privacy_policy_info, container, false);

        privacyPolicyImage = view.findViewById(R.id.privacyPolicyImage);
        privacyPolicyInfoDescription = view.findViewById(R.id.privacyPolicyInfoDescription);
        privacyPolicyInfoOkButton = view.findViewById(R.id.privacyPolicyInfoOkButton);

        try {
            if (getContext() != null) {
                int orientation = getResources().getConfiguration().orientation;
                String imageName = "";
                if (orientation == Configuration.ORIENTATION_PORTRAIT) {
                    imageName = "privacy_policy_portrait_custom";
                } else {
                    imageName = "privacy_policy_landscape_custom";
                }

                int resourceId = getResources().getIdentifier(imageName, "drawable", getContext().getPackageName());
                if (resourceId != 0) {
                    privacyPolicyImage.setBackgroundResource(resourceId);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        Locale loc;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            loc = getResources().getConfiguration().getLocales().get(0);
        } else {
            loc = getResources().getConfiguration().locale;
        }
        String deviceLocale = loc.getLanguage();

        String description = "";
        String ok = "";

        boolean privacyPolicyTextSet = false;

        for (PrivacyPolicy privacyPolicy : GamedockConfigManager.getInstance(getContext()).spil.privacyPolicies) {
            if (privacyPolicy.locale.equals(deviceLocale)) {
                description = privacyPolicy.info.description;
                ok = privacyPolicy.info.ok;

                privacyPolicyTextSet = true;
                break;
            }
        }

        if (!privacyPolicyTextSet) {
            PrivacyPolicy englishPrivacyPolicy = GamedockConfigManager.getInstance(getContext()).spil.getDefaultEnglishPrivacyPolicy();
            if (englishPrivacyPolicy != null) {
                description = englishPrivacyPolicy.main.description;
                ok = englishPrivacyPolicy.info.ok;
            } else {
                description = "";
                ok = "";
            }
        }

        privacyPolicyInfoDescription.setText(description);
        privacyPolicyInfoOkButton.setText(ok);

        privacyPolicyInfoOkButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onPrivacyPolicyInfoListener.OnInfoAccepted();
            }
        });

        return view;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof OnPrivacyPolicyInfoListener) {
            onPrivacyPolicyInfoListener = (OnPrivacyPolicyInfoListener) context;
        }
    }

    @Override
    public void onDetach() {
        super.onDetach();
        onPrivacyPolicyInfoListener = null;
    }

    public interface OnPrivacyPolicyInfoListener {
        void OnInfoAccepted();
    }

}
