package io.gamedock.sdk.utils.permissions;

import com.unity3d.player.UnityPlayer;

import org.json.JSONException;
import org.json.JSONObject;

import io.gamedock.sdk.utils.logging.LoggingUtil;

public class PermissionCallbacks {

    private OnPermissionListener permissionListener;

    public PermissionCallbacks() {
        permissionListener = null;
    }

    public PermissionCallbacks(OnPermissionListener permissionListener) {
        this.permissionListener = permissionListener;
    }

    public void permissionResponse(String permission, boolean granted, boolean permanentlyDenied) {
        if (permissionListener != null) {
            permissionListener.PermissionResponse(permission, granted, permanentlyDenied);
        } else {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("permission", permission);
                jsonObject.put("granted", granted);
                jsonObject.put("permanentlyDenied", permanentlyDenied);
                UnityPlayer.UnitySendMessage("GamedockSDK", "PermissionResponse", jsonObject.toString());
            } catch (JSONException | NoClassDefFoundError e) {
                LoggingUtil.w("Tried to send information to Unity but UnityPlayer could not be found (NoClassDefFoundError). This can happen by design and is not necessarily a problem.");
            }
        }
    }
}
