package io.gamedock.sdk.utils.performance;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Debug;

import static android.content.Context.ACTIVITY_SERVICE;

/**
 * Class used by the SDK to perform various CPU metrics operations.
 */
public class MemoryInfo {

    /**
     * Method used to retrieve the memory used by the current process (application).
     * @param context The application context.
     * @return The memory use in Mbs.
     */
    public static long getMemoryUsage(Context context) {
        long totalUsedSize = 0L;
        try {
            ActivityManager activityManager = (ActivityManager) context.getSystemService(ACTIVITY_SERVICE);
            Debug.MemoryInfo[] memoryInfos = activityManager.getProcessMemoryInfo(new int[] {android.os.Process.myPid()});

            if(memoryInfos != null) {
                totalUsedSize = memoryInfos[0].getTotalPss() / 1024L;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return totalUsedSize;
    }

    /**
     * Method used to retrieve the total available memory for this application.
     * @param context The application context.
     * @return The total memory in Mbs.
     */
    public static long getTotalMemory(Context context) {
        ActivityManager activityManager = (ActivityManager) context.getSystemService(ACTIVITY_SERVICE);
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();

        activityManager.getMemoryInfo(memoryInfo);

        return (memoryInfo.availMem / 1024L / 1024L);
    }

}
