package io.gamedock.sdk.utils.other;


import java.util.ArrayList;

/**
 * Utility Class used for providing a simple limited size queue.
 * Used for tracking duplicate events.
 *
 * @param <K>
 */
public class LimitedSizeQueue<K> {

    private int maxSize;
    public ArrayList<K> list;

    public LimitedSizeQueue(int maxSize) {
        this.maxSize = maxSize;
    }

    public boolean add(K k) {
        boolean r = list.add(k);

        if (list.size() > maxSize) {
            list.remove(0);
        }

        return r;
    }

    public K getYoungest() {
        return list.get(list.size() - 1);
    }

    public K getOldest() {
        return list.get(0);
    }
}
