package io.gamedock.sdk.utils.other;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

import io.gamedock.sdk.utils.logging.LoggingUtil;

public class GZIPCompression {

    public static byte[] compress(String payload) throws IOException {
        ByteArrayOutputStream os = null;
        GZIPOutputStream gos = null;
        try {
            os = new ByteArrayOutputStream(payload.length());
            gos = new GZIPOutputStream(os);
            gos.write(payload.getBytes());
            gos.close();
            byte[] compressed = os.toByteArray();
            os.close();
            return compressed;
        } finally {
            if (os != null) {
                try {
                    os.close();
                } catch (IOException e) {
                    LoggingUtil.i("Error closing ByteArrayOutputStream");
                }
            }

            if (gos != null) {
                try {
                    gos.close();
                } catch (IOException e) {
                    LoggingUtil.i("Error closing GZIPOutputStream");
                }
            }
        }
    }

    public static String decompress(byte[] compressed) throws IOException {
        final int BUFFER_SIZE = 32;
        ByteArrayInputStream is = new ByteArrayInputStream(compressed);
        GZIPInputStream gis = new GZIPInputStream(is, BUFFER_SIZE);
        StringBuilder string = new StringBuilder();
        byte[] data = new byte[BUFFER_SIZE];
        int bytesRead;
        while ((bytesRead = gis.read(data)) != -1) {
            string.append(new String(data, 0, bytesRead));
        }
        gis.close();
        is.close();
        return string.toString();
    }

}
