package io.gamedock.sdk.utils.agegate;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import java.util.Locale;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.R;
import io.gamedock.sdk.config.internal.GamedockConfigManager;
import io.gamedock.sdk.models.config.AgeGate;
import io.gamedock.sdk.utils.storage.StorageUtil;

public class AgeGateActivity extends Activity {

    private static final String AGE_RANGE_1 = "0-12";
    private static final String AGE_RANGE_2 = "13-15";
    private static final String AGE_RANGE_3 = "16+";

    public AgeGateActivity activity;

    private TextView ageGateQuestion;
    private TextView ageGateDescription;
    private TextView ageGateRejectMessage;

    private Button ageGateFirstChoiceButton;
    private Button ageGateSecondChoiceButton;
    private Button ageGateThirdChoiceButton;

    private String question = "";
    private String description = "";
    private String rejectMessage = "";

    private int ageGateRequirement;
    private boolean ageGateShouldBlock;

    @SuppressLint("ClickableViewAccessibility")
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_age_gate);

        activity = this;

        try {
            overridePendingTransition(android.R.anim.slide_in_left, android.R.anim.slide_out_right);
        } catch (Exception e) {
        }

        ImageView ageGateImage = findViewById(R.id.ageGateImage);
        ageGateQuestion = findViewById(R.id.ageGateQuestion);
        ageGateDescription = findViewById(R.id.ageGateDescription);
        ageGateFirstChoiceButton = findViewById(R.id.ageGateFirstChoiceButton);
        ageGateSecondChoiceButton = findViewById(R.id.ageGateSecondChoiceButton);
        ageGateThirdChoiceButton = findViewById(R.id.ageGateThirdChoiceButton);
        ageGateRejectMessage = findViewById(R.id.ageGateRejectMessage);

        try {
            int orientation = getResources().getConfiguration().orientation;
            String imageName = orientation == Configuration.ORIENTATION_PORTRAIT ? "privacy_policy_portrait_custom" : "privacy_policy_landscape_custom";

            int resourceId = getResources().getIdentifier(imageName, "drawable", getPackageName());
            if (resourceId != 0) {
                ageGateImage.setBackgroundResource(resourceId);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        Locale loc;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            loc = getResources().getConfiguration().getLocales().get(0);
        } else {
            loc = getResources().getConfiguration().locale;
        }
        String deviceLocale = loc.getLanguage();

        boolean ageGateTextSet = false;

        for (AgeGate ageGate : GamedockConfigManager.getInstance(activity).spil.ageGates) {
            if (ageGate.locale.equals(deviceLocale)) {
                question = ageGate.question;
                description = ageGate.description;
                rejectMessage = ageGate.rejectMessage;

                ageGateTextSet = true;
                break;
            }
        }

        if (!ageGateTextSet) {
            AgeGate englishAgeGate = GamedockConfigManager.getInstance(activity).spil.getDefaultEnglishAgeGate();
            if (englishAgeGate != null) {
                question = englishAgeGate.question;
                description = englishAgeGate.description;
                rejectMessage = englishAgeGate.rejectMessage;
            } else {
                question = "";
                description = "";
                rejectMessage = "";
            }
        }

        Bundle args = getIntent().getExtras();
        if (args != null) {
            ageGateRequirement = args.getInt("ageGateRequirement", 0);
            ageGateShouldBlock = args.getBoolean("ageGateShouldBlock", false);
        } else {
            return;
        }

        ageGateQuestion.setText(question);
        ageGateDescription.setText(description);

        View.OnTouchListener touchListener = new View.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == MotionEvent.ACTION_DOWN) {
                    Button button = (Button) v;
                    button.setBackground(getResources().getDrawable(R.drawable.accept_button_highlight));
                    return true;
                } else if (event.getAction() == MotionEvent.ACTION_UP) {
                    Button button = (Button) v;
                    button.setBackground(getResources().getDrawable(R.drawable.accept_button));
                    button.performClick();
                    return true;
                }
                return false;
            }
        };

        ageGateFirstChoiceButton.setText("0-12");
        ageGateFirstChoiceButton.setOnTouchListener(touchListener);
        ageGateFirstChoiceButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                checkAge(AGE_RANGE_1);
            }
        });

        ageGateSecondChoiceButton.setText("13-15");
        ageGateSecondChoiceButton.setOnTouchListener(touchListener);
        ageGateSecondChoiceButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                checkAge(AGE_RANGE_2);
            }
        });

        ageGateThirdChoiceButton.setText("16+");
        ageGateThirdChoiceButton.setOnTouchListener(touchListener);
        ageGateThirdChoiceButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                checkAge(AGE_RANGE_3);
            }
        });

        GamedockSDK.getInstance(this).getStorageUtil().putBoolean(StorageUtil.Keys.AgeGateWasShowing, true);
    }


    private void checkAge(String ageRange) {
        switch (ageRange) {
            case AGE_RANGE_1:
                if (ageGateShouldBlock) {
                    if (ageGateRequirement > 12) {
                        setAgeGateRetries(AGE_RANGE_1);
                    } else {
                        setAgeGateValues(AGE_RANGE_1, false);

                        finish();
                    }
                } else {
                    setAgeGateValues(AGE_RANGE_1, false);

                    finish();
                }
                break;
            case AGE_RANGE_2:
                if (ageGateShouldBlock) {
                    if (ageGateRequirement > 15) {
                        setAgeGateRetries(AGE_RANGE_2);
                    } else {
                        setAgeGateValues(AGE_RANGE_2, false);

                        finish();
                    }
                } else {
                    setAgeGateValues(AGE_RANGE_2, false);

                    finish();
                }
                break;
            case AGE_RANGE_3:
                setAgeGateValues(AGE_RANGE_3, true);

                finish();
                break;
        }
    }

    private void setAgeGateRetries(String ageRange) {
        ageGateQuestion.setVisibility(View.INVISIBLE);

        ageGateRejectMessage.setVisibility(View.VISIBLE);
        if (rejectMessage.contains("#")) {
            rejectMessage = rejectMessage.replace("#", String.valueOf(ageGateRequirement));
        }
        ageGateRejectMessage.setText(rejectMessage);

        GamedockSDK.getInstance(activity).getAgeGateCallbacks().ageGateStatus(false, ageRange, false);
    }

    private void setAgeGateValues(String ageRange, boolean checkPrivacyPolicy) {
        GamedockSDK.getInstance(activity).getStorageUtil().putString(StorageUtil.Keys.AgeGateAge, ageRange);
        GamedockSDK.getInstance(activity).getStorageUtil().putBoolean(StorageUtil.Keys.AgeGateAsked, true);
        GamedockSDK.getInstance(activity).getStorageUtil().putBoolean(StorageUtil.Keys.AgeGatePassed, true);

        if (GamedockSDK.getInstance(activity).initializationOptions != null) {
            if (GamedockSDK.getInstance(activity).initializationOptions.isWithAutoProcessAgeGate()) {
                if (GamedockSDK.getInstance(activity).initializationOptions.isWithPrivacyPolicy() && checkPrivacyPolicy) {
                    GamedockSDK.getInstance(activity).checkPrivacyPolicy(true);
                } else {
                    GamedockSDK.getInstance(activity).init(false, true);
                }
            }
        }

        GamedockSDK.getInstance(this).getStorageUtil().putBoolean(StorageUtil.Keys.AgeGateWasShowing, false);

        GamedockSDK.getInstance(activity).getAgeGateCallbacks().ageGateStatus(true, ageRange, checkPrivacyPolicy);
    }

    @Override
    public void onBackPressed() {

    }

    @Override
    protected void onDestroy() {
        super.onDestroy();

        GamedockSDK.getInstance(activity).isShowingAgeGate = false;
        GamedockSDK.getInstance(activity).isShowingChildActivity = false;
        activity = null;
    }
}
