package io.gamedock.sdk.models.userdata.inventory;

import com.google.gson.JsonObject;

import io.gamedock.sdk.models.gamedata.gacha.GachaContent;
import io.gamedock.sdk.models.gamedata.items.Item;

public class UniquePlayerItem extends Item {
    private String uniqueId;
    private int amount;
    private int delta;
    private String status;
    private JsonObject uniqueProperties;

    public UniquePlayerItem() {
        super();
    }

    public UniquePlayerItem(Item item) {
        setId(item.getId());
        setName(item.getName());
        setType(item.getType());
        setAmount(0);
        setDelta(0);
        status = "NONE";
        uniqueProperties = new JsonObject();
        setReportingName(item.getReportingName());
        setDisplayName(item.getDisplayName());
        setDisplayDescription(item.getDisplayDescription());
        setImageUrl(item.getImageUrl());

        setGacha(item.isGacha());
        setContent(item.getContent());
        setProperties(item.getProperties());
        setLimit(item.getLimit());
        setUnique(item.isUnique());
    }

    public String getUniqueId() {
        return uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public int getAmount() {
        return amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public int getDelta() {
        return delta;
    }

    public void setDelta(int delta) {
        this.delta = delta;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public JsonObject getUniqueProperties() {
        return uniqueProperties;
    }

    public void setUniqueProperties(JsonObject uniqueProperties) {
        this.uniqueProperties = uniqueProperties;
    }

    public UniquePlayerItem clone() {
        UniquePlayerItem clone = new UniquePlayerItem();

        clone.setUniqueId(uniqueId);
        clone.setAmount(amount);
        clone.setDelta(delta);
        clone.setStatus(status);
        clone.setUniqueProperties(uniqueProperties);

        clone.setId(getId());
        clone.setName(getName());
        clone.setInitialValue(getInitialValue());
        clone.setType(getType());
        clone.setReportingName(getReportingName());
        clone.setDisplayName(getDisplayName());
        clone.setDisplayDescription(getDisplayDescription());
        clone.setImageUrl(getImageUrl());

        clone.setGacha(isGacha());

        if(getContent() != null) {
            for (GachaContent gachaContent : getContent()) {
                clone.getContent().add(gachaContent.clone());
            }
        }

        clone.setProperties(getProperties());
        clone.setLimit(getLimit());
        clone.setUnique(isUnique());

        return clone;
    }
    
    public void populateValues(Item item) {
        setName(item.getName());
        setType(item.getType());
        setGacha(item.isGacha());
        setContent(item.getContent());
        setAllowDuplicates(item.doesAllowDuplicates());
        setShouldReroll(item.shouldReroll());
        setDuplicateReward(item.getDuplicateReward());
        setDisplayName(item.getDisplayName());
        setDisplayDescription(item.getDisplayDescription());
        setImageUrl(item.getImageUrl());
        setLimit(item.getLimit());
        setProperties(item.getProperties());
        setUnique(item.isUnique());
    }
}
